/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections.dialog.bodies;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.elements.sections.dialog.event.DialogRegisterEvent;
import com.shanebeestudios.nms.elements.sections.dialog.event.PlainMessageEvent;
import com.shanebeestudios.skbee.api.skript.base.Section;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.dialog.body.DialogBody;
import net.minecraft.server.dialog.body.ItemBody;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.SectionEntryData;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Dialog - Item Body")
@Description(value={"An item with optional description. It appears like it is in the inventory slot when the mouse hovers over the item. The size does not scale even if width and height are set to other values than the default. If the description is present, then it appears next to the right side of the item.", "See [**Item Body**](https://minecraft.wiki/w/Dialog#item) on McWiki for further details.", "NOTE: Not all entiries will be discussed here, see McWiki link above for all entries.", "**Entries**:", "- `item` = An ItemStack/ItemType that will show in the body of a dialog.", "- `description` = Accepts a Plain Message Body section to describe the item."})
@Examples(value={"add item body:", "\titem: diamond sword of unbreaking 3 damaged by 500", "\tdescription:", "\t\tadd plain message body:", "\t\t\tcontents: \"A Cool Item!\"", "\t\t\twidth: 300", "\tshow_decoration: true", "\tshow_tooltip: false"})
@Since(value={"1.3.0"})
public class SecItemBody
extends Section {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private Expression<ItemStack> item;
    private Trigger description;
    private Expression<Boolean> showDecoration;
    private Expression<Boolean> showTooltip;
    private Expression<Integer> width;
    private Expression<Integer> height;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(DialogRegisterEvent.class)) {
            Skript.error((String)"Item body can only be applied in a body section.");
            return false;
        }
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.item = (Expression)container.getOptional("item", false);
        this.showDecoration = (Expression)container.getOptional("show_decoration", false);
        this.showTooltip = (Expression)container.getOptional("show_tooltip", false);
        this.width = (Expression)container.getOptional("width", true);
        this.height = (Expression)container.getOptional("height", true);
        SectionNode descriptionNode = (SectionNode)container.getOptional("description", false);
        if (descriptionNode != null) {
            this.description = this.loadCode(descriptionNode, "description", new Class[]{PlainMessageEvent.class});
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        TriggerItem next = this.getNext();
        ItemStack item = (ItemStack)this.item.getSingle(event);
        boolean showDecoration = this.showDecoration == null || Boolean.TRUE.equals(this.showDecoration.getSingle(event));
        boolean showTooltip = this.showTooltip == null || Boolean.TRUE.equals(this.showTooltip.getSingle(event));
        int width = (Integer)this.width.getSingle(event);
        int height = (Integer)this.height.getSingle(event);
        Optional<Object> description = Optional.empty();
        if (this.description != null) {
            PlainMessageEvent plainMessageEvent = new PlainMessageEvent();
            Variables.withLocalVariables((Event)event, (Event)plainMessageEvent, () -> Trigger.walk((TriggerItem)this.description, (Event)plainMessageEvent));
            description = Optional.of(plainMessageEvent.getPlainMessage());
        }
        ItemBody itemBody = new ItemBody(CraftItemStack.asNMSCopy((ItemStack)item), description, showDecoration, showTooltip, width, height);
        if (event instanceof DialogRegisterEvent) {
            DialogRegisterEvent dialogRegisterEvent = (DialogRegisterEvent)event;
            dialogRegisterEvent.addBody((DialogBody)itemBody);
        }
        return next;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "add item body";
    }

    static {
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("item", null, false, ItemStack.class));
        VALIDATOR.addEntryData((EntryData)new SectionEntryData("description", null, true));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("show_decoration", null, true, Boolean.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("show_tooltip", null, true, Boolean.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("width", (Expression)new SimpleLiteral((Object)16, true), true, Integer.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("height", (Expression)new SimpleLiteral((Object)16, true), true, Integer.class));
        Skript.registerSection(SecItemBody.class, (String[])new String[]{"add item body"});
    }
}

