/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections.dialog.inputs;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.util.McUtils;
import com.shanebeestudios.nms.elements.sections.dialog.event.DialogRegisterEvent;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dialog.Input;
import net.minecraft.server.dialog.input.BooleanInput;
import net.minecraft.server.dialog.input.InputControl;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Dialog - Boolean Input")
@Description(value={"A simple checkbox input to be used in an `inputs` section of a dialog.", "See [**Input Control on SkNMS wiki**](https://github.com/ShaneBeee/SkNMS/wiki/Dialogs#input-control)and [**Input Control on McWiki**](https://minecraft.wiki/w/Dialog#Input_control_format) for further info.", "**Entries**:", "- `key` = String identifier of value used when submitting data, must be a valid template argument (letters, digits and _).", "- `label` = A string/text component to be displayed to the left of the input.", "- `initial` = The initial boolean value of the checkbox. Defaults to false (unchecked).", "- `on_true` = The string value to send when true. Defaults to \"true\".", "- `on_false` = The string value to send when false. Defaults to \"false\"."})
@Examples(value={"add boolean input:", "\tkey: \"some_bool_key\"", "\tlabel: \"Want some cheese?\"", "\tinitial: true", "\ton_true: \"true was selected\"", "\ton_false: \"false was selected\""})
@Since(value={"1.3.0"})
public class SecBooleanInput
extends Section {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private Expression<String> key;
    private Expression<?> label;
    private Expression<Boolean> initial;
    private Expression<String> onTrue;
    private Expression<String> onFalse;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(DialogRegisterEvent.class)) {
            Skript.error((String)"A boolean input can only be used in an 'inputs' section of a dialog.");
            return false;
        }
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.key = (Expression)container.getOptional("key", false);
        this.label = (Expression)container.getOptional("label", false);
        this.initial = (Expression)container.getOptional("initial", false);
        this.onTrue = (Expression)container.getOptional("on_true", false);
        this.onFalse = (Expression)container.getOptional("on_false", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        String onFalseSingle;
        String onTrueSingle;
        Boolean initialSingle;
        TriggerItem next = this.getNext();
        String key = (String)this.key.getSingle(event);
        if (key == null) {
            return next;
        }
        Object labelWrapped = this.label.getSingle(event);
        Component label = McUtils.getNMSComponent(labelWrapped);
        if (label == null) {
            this.error("Label is invalid: " + this.label.toString(event, true));
            return next;
        }
        boolean initial = false;
        if (this.initial != null && (initialSingle = (Boolean)this.initial.getSingle(event)) != null) {
            initial = initialSingle;
        }
        String onTrue = "true";
        if (this.onTrue != null && (onTrueSingle = (String)this.onTrue.getSingle(event)) != null) {
            onTrue = onTrueSingle;
        }
        String onFalse = "false";
        if (this.onFalse != null && (onFalseSingle = (String)this.onFalse.getSingle(event)) != null) {
            onFalse = onFalseSingle;
        }
        if (event instanceof DialogRegisterEvent) {
            DialogRegisterEvent registerEvent = (DialogRegisterEvent)event;
            BooleanInput booleanInput = new BooleanInput(label, initial, onTrue, onFalse);
            registerEvent.addInput(new Input(key, (InputControl)booleanInput));
        }
        return next;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "add boolean input";
    }

    static {
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("key", null, false, String.class));
        Class[] compClasses = new Class[]{String.class, ComponentWrapper.class};
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("label", null, false, compClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("initial", null, true, Boolean.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("on_true", null, true, String.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("on_false", null, true, String.class));
        Skript.registerSection(SecBooleanInput.class, (String[])new String[]{"add boolean input"});
    }
}

