/*
 * Decompiled with CFR 0.152.
 */
package com.shanebeestudios.nms.elements.sections.dialog.inputs;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.util.SimpleLiteral;
import ch.njol.util.Kleenean;
import com.shanebeestudios.nms.api.util.McUtils;
import com.shanebeestudios.nms.elements.sections.dialog.event.DialogRegisterEvent;
import com.shanebeestudios.skbee.api.skript.base.Section;
import com.shanebeestudios.skbee.api.wrapper.ComponentWrapper;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.dialog.Input;
import net.minecraft.server.dialog.input.InputControl;
import net.minecraft.server.dialog.input.TextInput;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;
import org.skriptlang.skript.lang.entry.EntryContainer;
import org.skriptlang.skript.lang.entry.EntryData;
import org.skriptlang.skript.lang.entry.EntryValidator;
import org.skriptlang.skript.lang.entry.util.ExpressionEntryData;

@Name(value="Dialog - Text Input")
@Description(value={"A text input to be used in an `inputs` section of a dialog.", "See [**Input Control on SkNMS wiki**](https://github.com/ShaneBeee/SkNMS/wiki/Dialogs#input-control)and [**Input Control on McWiki**](https://minecraft.wiki/w/Dialog#Input_control_format) for further info.", "**Entries**:", "- `key` = String identifier of value used when submitting data, must be a valid template argument (letters, digits and _).", "- `label` = A string/text component to be displayed to the left of the input.", "- `width` = Integer value between 1 and 1024 \u2014 The width of the input. Defaults to 200. [Optional]", "- `label_visible` = Controls if the label is visible. Defaults to true. [Optional]", "- `initial` = The initial string value of the text input. [Optional]", "- `max_length` = Maximum length of input. Defaults to 32. [Optional]", "- The next two represent `multiline` and if used, must be used together.", "If present, allows users to input multiple lines, optional object with entries:", "  - `multiline_max_lines` = Positive integer. If present, limits maximum lines.", "  - `multiline_height` = Integer value between 1 and 512 \u2014 Height of input."})
@Examples(value={"add text input:", "    key: \"name_input\"", "    label: \"Input your name to confirm:\"", "    initial: \"name\""})
@Since(value={"1.3.0"})
public class SecTextInput
extends Section {
    private static final EntryValidator.EntryValidatorBuilder VALIDATOR = EntryValidator.builder();
    private Expression<String> key;
    private Expression<?> label;
    private Expression<Integer> width;
    private Expression<Boolean> labelVisible;
    private Expression<String> initial;
    private Expression<Integer> maxLength;
    private Expression<Integer> multiline_max_lines;
    private Expression<Integer> multiline_height;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult, SectionNode sectionNode, List<TriggerItem> triggerItems) {
        if (!this.getParser().isCurrentEvent(DialogRegisterEvent.class)) {
            Skript.error((String)"A text input can only be used in an 'inputs' section of a dialog.");
            return false;
        }
        EntryContainer container = VALIDATOR.build().validate(sectionNode);
        if (container == null) {
            return false;
        }
        this.key = (Expression)container.getOptional("key", false);
        this.label = (Expression)container.getOptional("label", false);
        this.initial = (Expression)container.getOptional("initial", false);
        this.labelVisible = (Expression)container.getOptional("label_visible", false);
        this.maxLength = (Expression)container.getOptional("max_length", false);
        this.width = (Expression)container.getOptional("width", false);
        this.multiline_max_lines = (Expression)container.getOptional("multiline_max_lines", false);
        this.multiline_height = (Expression)container.getOptional("multiline_height", false);
        return true;
    }

    @Nullable
    protected TriggerItem walk(Event event) {
        Integer intSingle;
        Boolean single;
        String s;
        Integer intSingle2;
        TriggerItem next = this.getNext();
        String key = (String)this.key.getSingle(event);
        if (key == null) {
            return next;
        }
        Object labelWrapped = this.label.getSingle(event);
        Component label = McUtils.getNMSComponent(labelWrapped);
        if (label == null) {
            this.error("Label is invalid: " + this.label.toString(event, true));
            return next;
        }
        int width = 200;
        if (this.width != null && (intSingle2 = (Integer)this.width.getSingle(event)) != null) {
            width = intSingle2;
        }
        String initial = "";
        if (this.initial != null && (s = (String)this.initial.getSingle(event)) != null) {
            initial = s;
        }
        boolean labelVisible = true;
        if (this.labelVisible != null && (single = (Boolean)this.labelVisible.getSingle(event)) != null) {
            labelVisible = single;
        }
        int maxLength = 32;
        if (this.maxLength != null && (intSingle = (Integer)this.maxLength.getSingle(event)) != null) {
            maxLength = intSingle;
        }
        Optional<Object> multilineOptions = Optional.empty();
        if (this.multiline_max_lines != null && this.multiline_height != null) {
            Integer maxLines = (Integer)this.multiline_max_lines.getSingle(event);
            Integer height = (Integer)this.multiline_height.getSingle(event);
            if (maxLines != null && height != null) {
                TextInput.MultilineOptions options = new TextInput.MultilineOptions(Optional.of(maxLines), Optional.of(height));
                multilineOptions = Optional.of(options);
            }
        }
        if (event instanceof DialogRegisterEvent) {
            DialogRegisterEvent actionEvent = (DialogRegisterEvent)event;
            TextInput textInput = new TextInput(width, label, labelVisible, initial, maxLength, multilineOptions);
            actionEvent.addInput(new Input(key, (InputControl)textInput));
        }
        return next;
    }

    public String toString(@Nullable Event e, boolean d) {
        return "add text input";
    }

    static {
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("key", null, false, String.class));
        Class[] compClasses = new Class[]{String.class, ComponentWrapper.class};
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("label", null, false, compClasses));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("width", (Expression)new SimpleLiteral((Object)200, true), true, Integer.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("label_visible", null, true, Boolean.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("initial", null, true, String.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("max_length", null, true, Integer.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("multiline_max_lines", null, true, Integer.class));
        VALIDATOR.addEntryData((EntryData)new ExpressionEntryData("multiline_height", null, true, Integer.class));
        Skript.registerSection(SecTextInput.class, (String[])new String[]{"add text input"});
    }
}

