/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;

public abstract class WidgetContainer
extends WidgetBase {
    protected final List<WidgetBase> subWidgets = new ArrayList<WidgetBase>();
    @Nullable
    protected WidgetBase hoveredSubWidget = null;

    public WidgetContainer(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    protected <T extends WidgetBase> T addWidget(T widget) {
        this.subWidgets.add(widget);
        return widget;
    }

    protected <T extends ButtonBase> T addButton(T button, IButtonActionListener listener) {
        button.setActionListener(listener);
        this.addWidget(button);
        return button;
    }

    protected void addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        if (lines != null && lines.length >= 1) {
            if (width == -1) {
                for (String line : lines) {
                    width = Math.max(width, this.getStringWidth(line));
                }
            }
            WidgetLabel label = new WidgetLabel(x, y, width, height, textColor, lines);
            this.addWidget(label);
        }
    }

    @Override
    public boolean onMouseClicked(class_11909 click, boolean doubleClick) {
        boolean handled = false;
        if (this.isMouseOver((int)click.comp_4798(), (int)click.comp_4799())) {
            if (!this.subWidgets.isEmpty()) {
                for (WidgetBase widget : this.subWidgets) {
                    if (!widget.isMouseOver((int)click.comp_4798(), (int)click.comp_4799()) || !widget.onMouseClicked(click, doubleClick)) continue;
                    handled = true;
                }
            }
            if (!handled) {
                handled = this.onMouseClickedImpl(click, doubleClick);
            }
        }
        return handled;
    }

    @Override
    public void onMouseReleased(class_11909 click) {
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                widget.onMouseReleased(click);
            }
        }
        this.onMouseReleasedImpl(click);
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.isMouseOver((int)mouseX, (int)mouseY)) {
            if (!this.subWidgets.isEmpty()) {
                for (WidgetBase widget : this.subWidgets) {
                    if (!widget.onMouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount)) continue;
                    return true;
                }
            }
            return this.onMouseScrolledImpl(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        return false;
    }

    @Override
    public boolean onKeyTyped(class_11908 input) {
        boolean handled = false;
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                if (!widget.onKeyTyped(input)) continue;
                handled = true;
            }
        }
        if (!handled) {
            handled = this.onKeyTypedImpl(input);
        }
        return handled;
    }

    @Override
    public boolean onCharTyped(class_11905 input) {
        boolean handled = false;
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                if (!widget.onCharTyped(input)) continue;
                handled = true;
            }
        }
        if (!handled) {
            handled = this.onCharTypedImpl(input);
        }
        return handled;
    }

    @Override
    public void render(class_332 drawContext, int mouseX, int mouseY, boolean selected) {
        super.render(drawContext, mouseX, mouseY, selected);
        this.drawSubWidgets(drawContext, mouseX, mouseY);
    }

    @Override
    public void postRenderHovered(class_332 drawContext, int mouseX, int mouseY, boolean selected) {
        super.postRenderHovered(drawContext, mouseX, mouseY, selected);
        this.drawHoveredSubWidget(drawContext, mouseX, mouseY);
    }

    protected void drawSubWidgets(class_332 drawContext, int mouseX, int mouseY) {
        this.hoveredSubWidget = null;
        if (!this.subWidgets.isEmpty()) {
            for (WidgetBase widget : this.subWidgets) {
                widget.render(drawContext, mouseX, mouseY, false);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredSubWidget = widget;
            }
        }
    }

    protected void drawHoveredSubWidget(class_332 drawContext, int mouseX, int mouseY) {
        if (this.hoveredSubWidget != null) {
            this.hoveredSubWidget.postRenderHovered(drawContext, mouseX, mouseY, false);
        }
    }
}

