/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.InfoUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;

public record DirectoryCreator(Path dir, @Nullable IDirectoryNavigator navigator) implements IStringConsumerFeedback
{
    @Override
    public boolean setString(String string) {
        if (string.isEmpty()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_create_directory", string);
            return false;
        }
        Path file = this.dir().resolve(string);
        if (Files.exists(file, new LinkOption[0])) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_or_directory_already_exists", file.toAbsolutePath());
            return false;
        }
        try {
            Files.createDirectory(file, new FileAttribute[0]);
        }
        catch (Exception err) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_create_directory", file.toAbsolutePath());
            return false;
        }
        if (this.navigator() != null) {
            this.navigator().switchToDirectory(file);
        }
        InfoUtils.showGuiOrActionBarMessage(Message.MessageType.SUCCESS, "malilib.message.directory_created", string);
        return true;
    }
}

