/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.game;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibReference;
import fi.dy.masa.malilib.mixin.recipe.IMixinClientRecipeBook;
import fi.dy.masa.malilib.mixin.recipe.IMixinIngredient;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10294;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10300;
import net.minecraft.class_10301;
import net.minecraft.class_10302;
import net.minecraft.class_10314;
import net.minecraft.class_10315;
import net.minecraft.class_10352;
import net.minecraft.class_10355;
import net.minecraft.class_10363;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7699;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

public class RecipeBookUtils {
    private static final AnsiLogger LOGGER = new AnsiLogger(RecipeBookUtils.class, MaLiLibReference.DEBUG_MODE, true);
    public static class_10352 map;
    private static final int refreshTime = 300;
    private static long lastRefresh;

    public static void toggleDebugLog(boolean toggle) {
        LOGGER.toggleDebug(toggle);
    }

    public static void toggleAnsiColorLog(boolean toggle) {
        LOGGER.toggleAnsiColor(toggle);
    }

    public static String getRecipeCategoryId(class_10355 category) {
        class_5321 key = class_7923.field_54927.method_29113((Object)category).orElse(null);
        if (key != null) {
            return key.method_29177().toString();
        }
        return "";
    }

    @Nullable
    public static class_10355 getRecipeCategoryFromId(String id) {
        class_6880.class_6883 catReference = class_7923.field_54927.method_10223(class_2960.method_12829((String)id)).orElse(null);
        if (catReference != null && catReference.method_40227()) {
            return (class_10355)catReference.comp_349();
        }
        return null;
    }

    @Nullable
    public static class_10352 getMap(class_310 mc) {
        if (mc.field_1687 == null) {
            return null;
        }
        if (map == null || System.currentTimeMillis() - lastRefresh > 300000L) {
            map = class_10363.method_65008((class_1937)mc.field_1687);
            lastRefresh = System.currentTimeMillis();
        }
        return map;
    }

    public static void clearMap() {
        map = null;
        lastRefresh = -1L;
    }

    public static List<Pair<class_10298, class_10297>> getDisplayEntryFromRecipeBook(class_1799 result, List<Type> types) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return null;
        }
        class_299 recipeBook = mc.field_1724.method_3130();
        Map<class_10298, class_10297> recipeMap = ((IMixinClientRecipeBook)recipeBook).malilib_getRecipeMap();
        ArrayList<Pair<class_10298, class_10297>> list = new ArrayList<Pair<class_10298, class_10297>>();
        class_7699 features = mc.field_1687.method_45162();
        class_10352 map = RecipeBookUtils.getMap(mc);
        if (map == null) {
            return null;
        }
        for (class_10298 id : recipeMap.keySet()) {
            class_1799 resultSlot;
            class_10297 entry = recipeMap.get(id);
            Type type = Type.fromRecipeDisplay(entry.comp_3263());
            if (!entry.comp_3266().isPresent() || !types.contains((Object)type) || !entry.comp_3263().method_64728(features) || entry.comp_3263().comp_3258() instanceof class_10302.class_10310 || (resultSlot = entry.comp_3263().comp_3258().method_64742(map)).method_7960() || !class_1799.method_7984((class_1799)result, (class_1799)resultSlot)) continue;
            list.add((Pair<class_10298, class_10297>)Pair.of((Object)id, (Object)entry));
            if (list.size() <= 2) continue;
            return list;
        }
        return list;
    }

    public static boolean matchClientRecipeBookEntry(class_1799 result, List<class_1799> recipeStacks, class_10297 entry, List<Type> allowed, class_310 mc) {
        if (mc.field_1687 == null || result.method_7960()) {
            return false;
        }
        class_10352 map = RecipeBookUtils.getMap(mc);
        if (map == null) {
            return false;
        }
        List stacks = entry.method_64730(map);
        LOGGER.debug("matchClientRecipeBookEntry() --> [{}] vs [{}]", recipeStacks, ((class_1799)stacks.getFirst()).toString());
        if (stacks.isEmpty()) {
            MaLiLib.LOGGER.warn("matchClientRecipeBookEntry(): Failed receiving crafting stacks for NetworkRecipeId: [{}] -- is it even a valid recipe?", (Object)entry.comp_3262().comp_3267());
            return false;
        }
        if (RecipeBookUtils.areStacksEqual(result, (class_1799)stacks.getFirst())) {
            if (entry.comp_3266().isPresent()) {
                return RecipeBookUtils.compareStacksAndIngredients(recipeStacks, (List)entry.comp_3266().get(), Type.fromRecipeDisplay(entry.comp_3263()), allowed);
            }
            return true;
        }
        return false;
    }

    public static boolean compareStacksAndIngredients(List<class_1799> left, List<class_1856> right, Type type, List<Type> allowed) {
        if (left.isEmpty() || right.isEmpty()) {
            LOGGER.debug("compareStacksAndIngredients() --> EMPTY!!!", new Object[0]);
            return false;
        }
        LOGGER.debug("compareStacksAndIngredients() Type: [{}] --> START", type.toString());
        if (LOGGER.isDebug()) {
            RecipeBookUtils.dumpStacks(left, "LF");
            RecipeBookUtils.dumpIngs(right, "RT");
        }
        if (type == Type.SHAPELESS && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareShapelessRecipe(left, right);
        }
        if (type == Type.SHAPED && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareShapedRecipe(left, right);
        }
        if (type == Type.STONECUTTER && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareStonecutterRecipe(left, right);
        }
        if (type == Type.FURNACE && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareFurnaceRecipe(left, right);
        }
        if (type == Type.SMITHING && allowed.contains((Object)type)) {
            return RecipeBookUtils.compareSmithingRecipe(left, right);
        }
        return false;
    }

    public static boolean compareShapedRecipe(List<class_1799> left, List<class_1856> right) {
        LOGGER.debug("compareShapedRecipe() --> size left [{}], right [{}]\n", left.size(), right.size());
        int lPos = 0;
        for (int i = 0; i < right.size(); ++i) {
            class_1799 lStack = left.get(lPos);
            while (lStack.method_7960() && ++lPos < 9) {
                lStack = left.get(lPos);
                LOGGER.debug(" compareShapedRecipe() [{}] left [{}] (Advance Left), right [{}]", lPos, lStack.toString(), i);
            }
            if (!RecipeBookUtils.checkMatchingItemsEach(lStack, lPos, i, right.get(i))) {
                LOGGER.debug(" FAIL (Shaped)", new Object[0]);
                return false;
            }
            ++lPos;
        }
        LOGGER.debug(" PASS (Shaped)", new Object[0]);
        return true;
    }

    public static boolean compareShapelessRecipe(List<class_1799> left, List<class_1856> right) {
        LOGGER.debug("compareShapelessRecipe() --> size left [{}], right [{}]", left.size(), right.size());
        for (int i = 0; i < left.size(); ++i) {
            class_1799 lStack = left.get(i);
            boolean pass = false;
            LOGGER.debug(" compareShapelessRecipe() [{}] left [{}] -->", i, lStack.toString());
            if (lStack.method_7960()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeBookUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                LOGGER.debug(" PASS-EACH", new Object[0]);
                pass = true;
            }
            if (pass) continue;
            LOGGER.debug(" FAIL (Shapeless)", new Object[0]);
            return false;
        }
        LOGGER.debug(" PASS (Shapeless)", new Object[0]);
        return true;
    }

    @ApiStatus.Experimental
    public static boolean compareStonecutterRecipe(List<class_1799> left, List<class_1856> right) {
        LOGGER.debug("compareStonecutterRecipe() --> size left [{}], right [{}]", left.size(), right.size());
        for (int i = 0; i < left.size(); ++i) {
            class_1799 lStack = left.get(i);
            boolean pass = false;
            LOGGER.debug(" compareStonecutterRecipe() [{}] left [{}] -->", i, lStack.toString());
            if (lStack.method_7960()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeBookUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                LOGGER.debug(" PASS-EACH", new Object[0]);
                pass = true;
            }
            if (pass) continue;
            LOGGER.debug(" FAIL (Stonecutter)", new Object[0]);
            return false;
        }
        LOGGER.debug(" PASS (Stonecutter)", new Object[0]);
        return true;
    }

    @ApiStatus.Experimental
    public static boolean compareFurnaceRecipe(List<class_1799> left, List<class_1856> right) {
        LOGGER.debug("compareFurnaceRecipe() --> size left [{}], right [{}]", left.size(), right.size());
        for (int i = 0; i < left.size(); ++i) {
            class_1799 lStack = left.get(i);
            boolean pass = false;
            LOGGER.debug(" compareFurnaceRecipe() [{}] left [{}] -->", i, lStack.toString());
            if (lStack.method_7960()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeBookUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                LOGGER.debug(" PASS-EACH", new Object[0]);
                pass = true;
            }
            if (pass) continue;
            LOGGER.debug(" FAIL (Furnace)", new Object[0]);
            return false;
        }
        LOGGER.debug(" PASS (Furnace)", new Object[0]);
        return true;
    }

    @ApiStatus.Experimental
    public static boolean compareSmithingRecipe(List<class_1799> left, List<class_1856> right) {
        LOGGER.debug("compareSmithingRecipe() --> size left [{}], right [{}]", left.size(), right.size());
        for (int i = 0; i < left.size(); ++i) {
            class_1799 lStack = left.get(i);
            boolean pass = false;
            LOGGER.debug(" compareSmithingRecipe() [{}] left [{}] -->", i, lStack.toString());
            if (lStack.method_7960()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeBookUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                LOGGER.debug(" PASS-EACH", new Object[0]);
                pass = true;
            }
            if (pass) continue;
            LOGGER.debug(" FAIL (Smithing)", new Object[0]);
            return false;
        }
        LOGGER.debug(" PASS (Smithing)", new Object[0]);
        return true;
    }

    private static boolean checkMatchingItemsEach(class_1799 lStack, int lPos, int i, class_1856 ri) {
        List rItems = ((IMixinIngredient)ri).malilib_getEntries().method_40239().toList();
        for (class_6880 rItem : rItems) {
            LOGGER.debug(" checkMatchingItemsEach() [{}] left [{}] / [{}] right [{}] -->", lPos, lStack, i, rItem.method_55840());
            if (ri.method_8093(lStack)) {
                LOGGER.debug(" valid (Test test)", new Object[0]);
                return true;
            }
            if (!RecipeBookUtils.areStacksEqual(lStack, new class_1799(rItem))) continue;
            LOGGER.debug(" valid (Stack test)", new Object[0]);
            return true;
        }
        LOGGER.debug(" !not valid (Default)", new Object[0]);
        return false;
    }

    public static boolean areStacksEqual(class_1799 left, class_1799 right) {
        return class_1799.method_7984((class_1799)left, (class_1799)right) && left.method_7947() == right.method_7947();
    }

    private static void dumpStacks(List<class_1799> stacks, String side) {
        int i = 0;
        LOGGER.info("DUMP [{}] -->", side);
        for (class_1799 stack : stacks) {
            LOGGER.info(" {}[{}] // [{}]", side, i, stack.toString());
            ++i;
        }
        LOGGER.info("DUMP END [{}]\n", side);
    }

    private static void dumpIngs(List<class_1856> ings, String side) {
        int i = 0;
        LOGGER.info("DUMP [{}] -->", side);
        for (class_1856 ing : ings) {
            List items = ((IMixinIngredient)ing).malilib_getEntries().method_40239().toList();
            ArrayList<String> list = new ArrayList<String>();
            for (class_6880 item : items) {
                list.add(item.method_55840());
            }
            LOGGER.info(" {}[{}] // {}", i, side, ((Object)list).toString());
            ++i;
        }
        LOGGER.info("DUMP END [{}]", side);
    }

    static {
        lastRefresh = -1L;
    }

    public static enum Type implements class_3542
    {
        FURNACE,
        SHAPED,
        SHAPELESS,
        SMITHING,
        STONECUTTER,
        UNKNOWN;

        public static final class_3542.class_7292<Type> CODEC;
        public static final class_9139<ByteBuf, Type> PACKET_CODEC;
        public static final ImmutableList<Type> VALUES;

        public static Type fromRecipeDisplay(class_10295 type) {
            class_10295 class_102952 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_10294.class, class_10301.class, class_10300.class, class_10314.class, class_10315.class}, (Object)class_102952, n)) {
                case 0 -> {
                    class_10294 ignored = (class_10294)class_102952;
                    yield FURNACE;
                }
                case 1 -> {
                    class_10301 ignored = (class_10301)class_102952;
                    yield SHAPELESS;
                }
                case 2 -> {
                    class_10300 ignored = (class_10300)class_102952;
                    yield SHAPED;
                }
                case 3 -> {
                    class_10314 ignored = (class_10314)class_102952;
                    yield SMITHING;
                }
                case 4 -> {
                    class_10315 ignored = (class_10315)class_102952;
                    yield STONECUTTER;
                }
                default -> UNKNOWN;
            };
        }

        @Nullable
        public static Type fromStringStatic(String input) {
            for (Type type : Type.values()) {
                if (!type.name().equalsIgnoreCase(input)) continue;
                return type;
            }
            return null;
        }

        @Nonnull
        public String method_15434() {
            return this.name().toLowerCase();
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
            PACKET_CODEC = class_9135.field_48554.method_56432(Type::fromStringStatic, Type::method_15434);
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

