/*
 * Decompiled with CFR 0.152.
 */
package net.saganetwork.codeWhitelist;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class LanguageManager {
    private final Plugin plugin;
    private final Map<String, String> messages = new HashMap<String, String>();

    public LanguageManager(Plugin plugin) {
        this.plugin = plugin;
        this.loadLanguage();
    }

    public void loadLanguage() {
        YamlConfiguration langConfig;
        String language = this.plugin.getConfig().getString("language", "en");
        File langFile = new File(this.plugin.getDataFolder(), "translate/" + language + ".yml");
        if (!langFile.exists()) {
            this.plugin.getLogger().warning("Dil dosyas\u0131 bulunamad\u0131: " + language + ". Varsay\u0131lan dil kullan\u0131lacak.");
            langFile = new File(this.plugin.getDataFolder(), "translate/en.yml");
        }
        if ((langConfig = YamlConfiguration.loadConfiguration((File)langFile)).contains("messages")) {
            for (String key : langConfig.getConfigurationSection("messages").getKeys(false)) {
                this.messages.put(key, langConfig.getString("messages." + key, "Mesaj bulunamad\u0131: " + key));
            }
            this.plugin.getLogger().info("Dil dosyas\u0131 y\u00fcklendi: " + language);
        } else {
            this.plugin.getLogger().warning("Dil dosyas\u0131nda 'messages' b\u00f6l\u00fcm\u00fc bulunamad\u0131: " + language);
        }
    }

    public String getMessage(String key) {
        String rawMessage = this.messages.getOrDefault(key, "Mesaj bulunamad\u0131: " + key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)rawMessage);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String rawMessage = this.messages.getOrDefault(key, "Mesaj bulunamad\u0131: " + key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                rawMessage = rawMessage.replace("{" + entry.getKey() + "}", entry.getValue());
            }
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)rawMessage);
    }

    public TextComponent createClickableMessage(String text, String url) {
        TextComponent message = new TextComponent(ChatColor.translateAlternateColorCodes((char)'&', (String)text));
        message.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        return message;
    }
}

