/*
 * Decompiled with CFR 0.152.
 */
package net.saganetwork.codeWhitelist;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.md_5.bungee.api.chat.BaseComponent;
import net.saganetwork.codeWhitelist.LanguageManager;
import net.saganetwork.codeWhitelist.VersionChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private static final String BAN_CHECK_URL = "https://api.mcsunucun.com/CodeWhitelist/ban.php";
    private final Map<String, ItemStack[]> storedInventories = new HashMap<String, ItemStack[]>();
    private final Map<String, Boolean> frozenPlayers = new HashMap<String, Boolean>();
    private String serverCode;
    private VersionChecker versionChecker;
    private LanguageManager languageManager;

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveDefaultResources();
        this.setupConfigWithCode();
        this.languageManager = new LanguageManager((Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        String versionCheckUrl = "https://api.mcsunucun.com/CodeWhitelist/check.php";
        this.versionChecker = new VersionChecker((Plugin)this, versionCheckUrl);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, this.versionChecker::checkVersion);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> this.getLogger().info(this.languageManager.getMessage("verification_code_message").replace("{code}", this.serverCode)), 18000L, 18000L);
        this.getLogger().info(this.languageManager.getMessage("plugin_enabled"));
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.getLogger().info(this.languageManager.getMessage("server_code_console").replace("{code}", this.serverCode)), 60L);
    }

    public void onDisable() {
        this.getLogger().info(this.languageManager.getMessage("plugin_disabled"));
    }

    @EventHandler
    public void onAsyncPreLogin(AsyncPlayerPreLoginEvent event) {
        if (event.getAddress() == null) {
            return;
        }
        String playerIp = event.getAddress().getHostAddress();
        if (playerIp == null || playerIp.isEmpty()) {
            return;
        }
        if (this.isIpBanned(playerIp)) {
            Object message = this.languageManager != null ? this.languageManager.getMessage("ban_block_message") : String.valueOf(ChatColor.RED) + "CodeWhitelist taraf\u0131ndan engellendiniz.";
            event.disallow(AsyncPlayerPreLoginEvent.Result.KICK_OTHER, (String)message);
            this.getLogger().info("Banl\u0131 IP giri\u015f denemesi engellendi: " + playerIp);
        }
    }

    @EventHandler
    public void onPreLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        String playerHostname = event.getHostname();
        Player onlinePlayer = Bukkit.getPlayerExact((String)player.getName());
        if (onlinePlayer != null && onlinePlayer.isOnline() && onlinePlayer != player) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.languageManager.getMessage("duplicate_login_denied"));
            return;
        }
        FileConfiguration config = this.getConfig();
        boolean allowedLoginIPEnabled = config.getBoolean("settings.allowed-login-ip", false);
        String allowedLoginHostname = config.getString("settings.login-ip", "play.xxx.com");
        if (allowedLoginIPEnabled && !playerHostname.startsWith(allowedLoginHostname)) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.languageManager.getMessage("hostname_not_allowed"));
            this.getLogger().info(this.languageManager.getMessage("hostname_rejected").replace("{hostname}", playerHostname).replace("{player}", player.getName()));
            return;
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String playerIp = player.getAddress().getAddress().getHostAddress();
        FileConfiguration config = this.getConfig();
        boolean ipCheckEnabled = config.getBoolean("settings.ip-check", true);
        boolean isVerified = config.getStringList("players").contains(player.getName() + ":" + playerIp);
        if (ipCheckEnabled && isVerified) {
            player.sendMessage(this.languageManager.getMessage("ip_verified"));
            this.getLogger().info(this.languageManager.getMessage("server_ip_verified").replace("{playerip}", playerIp));
            return;
        }
        this.freezePlayer(player);
        this.storeAndClearInventory(player);
        player.sendTitle(this.languageManager.getMessage("title_required_code"), this.languageManager.getMessage("subtitle_required_code"), 10, 100, 10);
        player.sendMessage(this.languageManager.getMessage("frozen_message"));
        this.getLogger().info(this.languageManager.getMessage("server_not_verified").replace("{playerip}", playerIp));
        player.spigot().sendMessage((BaseComponent)this.languageManager.createClickableMessage(this.languageManager.getMessage("verification_guide_text"), "https://minecraftdocs.mcsunucun.com/panel-ek-ozellikleri/nasil-kod-alirim"));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        if (this.storedInventories.containsKey(playerName)) {
            player.getInventory().setContents(this.storedInventories.get(playerName));
            this.storedInventories.remove(playerName);
        }
        this.frozenPlayers.remove(playerName);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (this.isFrozen(player)) {
            event.setTo(event.getFrom());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.isFrozen(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player;
        HumanEntity humanEntity = event.getWhoClicked();
        if (humanEntity instanceof Player && this.isFrozen(player = (Player)humanEntity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.isFrozen(player = (Player)entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity = event.getDamager();
        if (entity instanceof Player && this.isFrozen(player = (Player)entity)) {
            event.setCancelled(true);
            player.sendMessage(this.languageManager.getMessage("cannot_attack"));
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().toLowerCase();
        if (!this.isFrozen(player)) {
            return;
        }
        if (command.startsWith("/kod ") || command.startsWith("/code ")) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(this.languageManager.getMessage("command_blocked"));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (label.equalsIgnoreCase("kod") || label.equalsIgnoreCase("code")) {
            if (args.length < 1) {
                sender.sendMessage(this.languageManager.getMessage("usage_command"));
                return true;
            }
            if (args[0].equalsIgnoreCase("al")) {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    if (!player.isOp()) {
                        player.sendMessage(this.languageManager.getMessage("no_permission"));
                        return true;
                    }
                    if (this.isFrozen(player)) {
                        player.sendMessage(this.languageManager.getMessage("command_blocked"));
                        return true;
                    }
                    player.sendMessage(this.languageManager.getMessage("server_code_console").replace("{code}", this.serverCode));
                } else {
                    sender.sendMessage(this.languageManager.getMessage("server_code_console").replace("{code}", this.serverCode));
                }
                return true;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.languageManager.getMessage("command_only_players"));
                return true;
            }
            Player player = (Player)sender;
            if (args[0].equals(this.serverCode)) {
                this.unfreezePlayer(player);
                this.restoreInventory(player);
                String playerIp = player.getAddress().getAddress().getHostAddress();
                FileConfiguration config = this.getConfig();
                List playerList = config.getStringList("players");
                playerList.add(player.getName() + ":" + playerIp);
                config.set("players", (Object)playerList);
                this.saveConfig();
                sender.sendMessage(this.languageManager.getMessage("verification_success"));
            } else {
                sender.sendMessage(this.languageManager.getMessage("invalid_code"));
            }
            return true;
        }
        return false;
    }

    private void freezePlayer(Player player) {
        this.frozenPlayers.put(player.getUniqueId().toString(), true);
        player.setWalkSpeed(0.0f);
    }

    private void unfreezePlayer(Player player) {
        this.frozenPlayers.remove(player.getUniqueId().toString());
        player.setWalkSpeed(0.2f);
    }

    private boolean isFrozen(Player player) {
        return this.frozenPlayers.getOrDefault(player.getUniqueId().toString(), false);
    }

    private void storeAndClearInventory(Player player) {
        String playerName = player.getName();
        if (this.storedInventories.containsKey(playerName)) {
            return;
        }
        this.storedInventories.put(playerName, player.getInventory().getContents());
        player.getInventory().clear();
    }

    private void restoreInventory(Player player) {
        String playerName = player.getName();
        if (this.storedInventories.containsKey(playerName)) {
            player.getInventory().setContents(this.storedInventories.get(playerName));
            this.storedInventories.remove(playerName);
        }
    }

    private void setupConfigWithCode() {
        FileConfiguration config = this.getConfig();
        if (!config.contains("server-code") || config.getString("server-code").isEmpty()) {
            this.serverCode = this.generateRandomCode();
            config.set("server-code", (Object)this.serverCode);
            this.saveConfig();
        } else {
            this.serverCode = config.getString("server-code");
        }
        if (!config.contains("players")) {
            config.set("players", new ArrayList());
        }
        if (!config.contains("settings.ip-check")) {
            config.set("settings.ip-check", (Object)true);
        }
        this.saveConfig();
    }

    private void saveDefaultResources() {
        this.saveResource("translate/en.yml", false);
        this.saveResource("translate/tr.yml", false);
        this.getLogger().info("Varsay\u0131lan dil dosyalar\u0131 olu\u015fturuldu.");
    }

    private String generateRandomCode() {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder code = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 6; ++i) {
            code.append(characters.charAt(random.nextInt(characters.length())));
        }
        return code.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isIpBanned(String playerIp) {
        try {
            String queryUrl = "https://api.mcsunucun.com/CodeWhitelist/ban.php?ip_check=" + URLEncoder.encode(playerIp, StandardCharsets.UTF_8);
            HttpURLConnection connection = (HttpURLConnection)new URL(queryUrl).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                return false;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                if (response.length() == 0) {
                    boolean bl = false;
                    return bl;
                }
                JsonObject json = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                if (!json.has("status")) return false;
                if (!json.get("status").isJsonPrimitive()) return false;
                boolean bl = json.get("status").getAsBoolean();
                return bl;
            }
        }
        catch (Exception e) {
            this.getLogger().warning("IP ban kontrol\u00fc s\u0131ras\u0131nda beklenmeyen bir hata olu\u015ftu: " + e.getMessage());
        }
        return false;
    }
}

