/*
 * Decompiled with CFR 0.152.
 */
package net.saganetwork.codeWhitelist;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.saganetwork.codeWhitelist.ExternalIpFetcher;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class VersionChecker {
    private final Plugin plugin;
    private final String versionCheckUrl;

    public VersionChecker(Plugin plugin, String versionCheckUrl) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin instance cannot be null.");
        }
        this.plugin = plugin;
        this.versionCheckUrl = versionCheckUrl;
    }

    public void checkVersion() {
        String currentVersion = this.plugin.getDescription().getVersion();
        if (currentVersion == null || currentVersion.isEmpty()) {
            this.plugin.getLogger().severe("Eklenti s\u00fcr\u00fcm\u00fc al\u0131namad\u0131. L\u00fctfen plugin.yml dosyas\u0131n\u0131 kontrol edin.");
            return;
        }
        String externalIp = ExternalIpFetcher.getExternalIp();
        if (externalIp.equals("0.0.0.0")) {
            this.plugin.getLogger().severe("Harici IP adresi al\u0131namad\u0131.");
            return;
        }
        int serverPort = Bukkit.getServer().getPort();
        String ipv4 = externalIp + ":" + serverPort;
        try {
            String line;
            String queryUrl = this.versionCheckUrl + "?ipv4=" + ipv4 + "&current_version=" + currentVersion;
            HttpURLConnection connection = (HttpURLConnection)new URL(queryUrl).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                this.plugin.getLogger().warning("API yan\u0131t\u0131 beklenmedik bir durumla kar\u015f\u0131la\u015ft\u0131: " + responseCode);
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            String responseText = response.toString();
            if (responseText.isEmpty()) {
                this.plugin.getLogger().severe("Bo\u015f yan\u0131t al\u0131nd\u0131, s\u00fcr\u00fcm kontrol\u00fc yap\u0131lamad\u0131.");
                return;
            }
            Gson gson = new Gson();
            JsonObject jsonResponse = (JsonObject)gson.fromJson(responseText, JsonObject.class);
            String latestVersion = jsonResponse.get("latest_version").getAsString();
            String updateUrl = jsonResponse.get("update_url").getAsString();
            if (currentVersion.equals(latestVersion)) {
                this.plugin.getLogger().info("CodeWhitelist'in en g\u00fcncel s\u00fcr\u00fcm\u00fcn\u00fc kullan\u0131yorsunuz: " + currentVersion);
            } else {
                this.plugin.getLogger().warning("CodeWhitelist i\u00e7in yeni bir s\u00fcr\u00fcm mevcut: " + latestVersion);
                this.plugin.getLogger().warning("G\u00fcncellemeyi buradan indir: " + updateUrl);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("S\u00fcr\u00fcm kontrol\u00fc s\u0131ras\u0131nda hata olu\u015ftu: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

