#version 150

#moj_import <minecraft:fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

vec3 applyVibrance(vec3 color, float strength) {
    float average = (color.r + color.g + color.b) / 3.0;
    float mx = max(max(color.r, color.g), color.b);
    float amt = (mx - average) * 2.0;           
    float vibrance = (1.0 - amt) * strength;    
    vec3 gray = vec3(average);
    return clamp(mix(gray, color, 1.0 + vibrance), 0.0, 1.0);
}

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;

#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif

    float vertexBrightness = max(max(vertexColor.r, vertexColor.g), vertexColor.b);
    float brightnessMult = 1.30;

    if (vertexBrightness <= 0.6420) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6380) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6340) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6300) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6260) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6220) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6180) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6140) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6100) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }
    if (vertexBrightness <= 0.6060) { color.rgb *= vec3(0.96511, 0.97798, 1.00153); }

    if (vertexBrightness <= 0.1960) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.1975) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.1990) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.2005) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.2020) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.2025) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.2040) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.2055) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.2070) { color.rgb *= vec3(0.966, 0.966, 0.976); }
    if (vertexBrightness <= 0.2085) { color.rgb *= vec3(0.966, 0.966, 0.976); }

    color.rgb *= brightnessMult;

    color.rgb = applyVibrance(color.rgb, 0.7);

    color.rgb = clamp(color.rgb, 0.0, 1.0);
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}

// by DR7 https://modrinth.com/user/DR7
