#version 150

// Adaptación directa del fog.glsl de Sodium a formato Vanilla-compatible

const int FOG_SHAPE_SPHERICAL = 0;
const int FOG_SHAPE_CYLINDRICAL = 1;

vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {

    // ----------- FOG 1 -----------
    float fogDensityStartMult1 = -0.2;
    float fogDensityEndMult1   = 2.0;

    float denseStart1 = fogStart * fogDensityStartMult1;
    float denseEnd1   = fogEnd   * fogDensityEndMult1;

    float factor1 = 0.0;
    if (vertexDistance > denseStart1) {
        factor1 = vertexDistance < denseEnd1 
            ? smoothstep(denseStart1, denseEnd1, vertexDistance)
            : 1.0;
    }

    // ----------- FOG 2 -----------
    float fogDensityStartMult2 = 0.96;
    float fogDensityEndMult2   = 1.0;

    float denseStart2 = fogStart * fogDensityStartMult2;
    float denseEnd2   = fogEnd   * fogDensityEndMult2;

    float factor2 = 0.0;
    if (vertexDistance > denseStart2) {
        factor2 = vertexDistance < denseEnd2 
            ? smoothstep(denseStart2, denseEnd2, vertexDistance)
            : 1.0;
    }

    // ----------- COMBINACIÓN -----------
    float factor = clamp((factor1 * 0.6) + (factor2 * 0.4), 0.0, 1.0);

    // ----------- TONO AZULADO DINÁMICO -----------
    float blueFactor = smoothstep(fogStart, fogEnd * 0.901, vertexDistance);
    vec3 blueTint = mix(vec3(1.0), vec3(0.9, 1.0, 1.2), blueFactor * 0.25);

    // ----------- APLICACIÓN FINAL -----------
    vec3 blended = mix(inColor.rgb, fogColor.rgb, factor * fogColor.a);
    blended *= blueTint;

    return vec4(blended, inColor.a);
}

float linear_fog_fade(float vertexDistance, float fogStart, float fogEnd) {
    float modifiedFogStart = fogStart;
    float modifiedFogEnd   = fogEnd;

    if (vertexDistance <= modifiedFogStart) {
        return 1.0;
    } else if (vertexDistance >= modifiedFogEnd) {
        return 0.0;
    }

    return smoothstep(modifiedFogEnd, modifiedFogStart, vertexDistance);
}

float fog_distance(vec3 pos, int shape) {
    if (shape == FOG_SHAPE_SPHERICAL) {
        return length(pos);
    } else if (shape == FOG_SHAPE_CYLINDRICAL) {
        float distXZ = length(pos.xz);
        float distY  = abs(pos.y);
        return max(distXZ, distY);
    } else {
        return length(pos);
    }
}
