#version 150

vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {
    // RENDER DISTANCE FOG
    float modifiedFogStart1 = fogStart * 0.96;  
    float modifiedFogEnd1   = fogEnd * 1.0;    

    float fogValue1 = 0.0;
    if (vertexDistance > modifiedFogStart1) {
        fogValue1 = vertexDistance < modifiedFogEnd1 
            ? smoothstep(modifiedFogStart1, modifiedFogEnd1, vertexDistance) 
            : 1.0;
    }

    vec3 celeste1 = vec3(1);
    vec3 finalFogColor1 = fogColor.rgb * celeste1; 

    float brightness = max(max(inColor.r, inColor.g), inColor.b);
    float bloomFactor = smoothstep(0.8, 1.0, brightness);
    vec3 bloomColor = vec3(2, -0.2, -0.2);

    finalFogColor1 += bloomColor * bloomFactor * 0.025;

    vec3 fogged1 = mix(inColor.rgb, finalFogColor1, fogValue1 * fogColor.a);

    // ENVIROMENTAL FOG
    float modifiedFogStart2 = fogStart * -0.2;  
    float modifiedFogEnd2   = fogEnd * 2.0;    

    float fogValue2 = 0.0;
    if (vertexDistance > modifiedFogStart2) {
        fogValue2 = vertexDistance < modifiedFogEnd2 
            ? smoothstep(modifiedFogStart2, modifiedFogEnd2, vertexDistance) 
            : 1.0;
    }

    vec3 celeste2 = vec3(0.9, 1.0, 1.2);
    vec3 finalFogColor2 = fogColor.rgb * celeste2; 

    finalFogColor2 += bloomColor * bloomFactor * 0.025;

    vec3 fogged2 = mix(fogged1, finalFogColor2, fogValue2 * fogColor.a);

    return vec4(fogged2, inColor.a);
}

float linear_fog_fade(float vertexDistance, float fogStart, float fogEnd) {
    float modifiedFogStart = fogStart * 0.2; 
    float modifiedFogEnd   = fogEnd * 2.0;

    if (vertexDistance <= modifiedFogStart) {
        return 1.0;
    } else if (vertexDistance >= modifiedFogEnd) {
        return 0.0;
    }

    return smoothstep(modifiedFogEnd, modifiedFogStart, vertexDistance);
}

float fog_distance(vec3 pos, int shape) {
    if (shape == 0) {
        return length(pos);
    } else {
        float distXZ = length(pos.xz);
        float distY  = abs(pos.y);
        return max(distXZ, distY);
    }
}

// by DR7 https://modrinth.com/user/DR7