#version 330

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
#ifdef PER_FACE_LIGHTING
in vec4 vertexPerFaceColorBack;
in vec4 vertexPerFaceColorFront;
#else
in vec4 vertexColor;
#endif
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0);
#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif
#ifdef PER_FACE_LIGHTING
    vec4 vColor = gl_FrontFacing ? vertexPerFaceColorFront : vertexPerFaceColorBack;
    color *= vColor * ColorModulator;
#else
    color *= vertexColor * ColorModulator;
    vec4 vColor = vertexColor;
#endif
#ifndef NO_OVERLAY
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
#endif
#ifndef EMISSIVE
    color *= lightMapColor;
#endif

    float vertexBrightness = max(max(vColor.r, vColor.g), vColor.b);

    if (vertexBrightness <= 0.6420) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6380) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6340) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6300) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6260) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6220) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6180) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6140) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6100) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6060) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.1960) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.1975) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.1990) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2005) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2020) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2025) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2040) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2055) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2070) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2085) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }

    color.rgb *= 1.3;

    float gray = dot(color.rgb, vec3(0.299, 0.587, 0.114)); // luminancia estándar
    color.rgb = mix(vec3(gray), color.rgb, 1.3);

    fragColor = apply_fog(
        color,
        sphericalVertexDistance,
        cylindricalVertexDistance,
        FogEnvironmentalStart,
        FogEnvironmentalEnd,
        FogRenderDistanceStart,
        FogRenderDistanceEnd,
        FogColor
    );
}

//by DR7 https://modrinth.com/user/DR7