#version 150

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:dynamictransforms.glsl>

uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
    vec4 baseColor = texture(Sampler0, texCoord0);
    vec4 color = baseColor * vertexColor * ColorModulator;

#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif

    float vertexBrightness = max(max(vertexColor.r, vertexColor.g), vertexColor.b);
    const float brightnessMult = 1.30; // preservado tal cual del snippet original

    if (vertexBrightness <= 0.6420) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6380) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6340) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6300) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6260) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6220) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6180) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6140) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6100) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.6060) {
        color.rgb *= vec3(0.96844, 0.97131, 1.00486);
    }
    if (vertexBrightness <= 0.1960) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.1975) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.1990) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2005) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2020) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2025) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2040) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2055) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2070) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    if (vertexBrightness <= 0.2085) { 
       color.rgb *= vec3(0.976, 0.976, 0.986); }
    
    vec3 brightened = color.rgb * 1.3;

    float intensity = dot(brightened, vec3(0.299, 0.587, 0.114));
    vec3 saturated = mix(vec3(intensity), brightened, 1.3);

    vec4 finalColor = vec4(saturated, color.a);

    fragColor = apply_fog(finalColor,
                          sphericalVertexDistance, cylindricalVertexDistance,
                          FogEnvironmentalStart, FogEnvironmentalEnd,
                          FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
}

//by DR7 https://modrinth.com/user/DR7