#version 330

#moj_import <minecraft:fog.glsl>
#moj_import <minecraft:chunksection.glsl>
#moj_import <utils.glsl>
#moj_import <fragment_utils.glsl>
#moj_import <minecraft:chunk_effects.glsl>
uniform sampler2D Sampler0;

in float sphericalVertexDistance;
in float cylindricalVertexDistance;
in vec4 vertexColor;
in vec2 texCoord0;
in vec3 vertexPosition;

out vec4 fragColor;

vec4 sampleNearest(sampler2D sampler, vec2 uv, vec2 pixelSize) {
    // Figure out how big a texel is on the screen, more or less
	vec2 du = dFdx(uv);
	vec2 dv = dFdy(uv);
	vec2 texelScreenSize = sqrt(du * du + dv * dv);

    // Convert our UV back up to texel coordinates and find out how far over we are from the center of each pixel
	vec2 uvTexelCoords = uv / pixelSize;
	vec2 texelCenter = round(uvTexelCoords) - 0.5f;
	vec2 texelOffset = uvTexelCoords - texelCenter;

    // Move our offset closer to the texel center based on texel size on screen
	texelOffset = (texelOffset - 0.5f) * pixelSize / texelScreenSize + 0.5f;
	texelOffset = clamp(texelOffset, 0.0f, 1.0f);

	uv = (texelCenter + texelOffset) * pixelSize;
	return textureGrad(sampler, uv, du, dv);
}

void main() {
    vec4 color = sampleNearest(Sampler0, texCoord0, 1.0f / TextureSize) * vertexColor;
   // color = mix(FogColor * vec4(1, 1, 1, color.a), color, ChunkVisibility);
    
    if (useTransparentFadeIn) {
        vec4 tColor = vec4(ChunkVisibility);
        dither(tColor,gl_FragCoord.xy);
    }


    if (useTransparentRenderDistanceFog) {
        float fogValue = 1-total_fog_value(sphericalVertexDistance, cylindricalVertexDistance, 10000000, 1000000, FogRenderDistanceStart, FogRenderDistanceEnd);
        vec4 tColor = vec4(fogValue);
        dither(vec4(tColor),gl_FragCoord.xy);
    }

#ifdef ALPHA_CUTOUT
    if (color.a < ALPHA_CUTOUT) {
        discard;
    }
#endif
    fragColor = apply_fog(color, sphericalVertexDistance, cylindricalVertexDistance, FogEnvironmentalStart, FogEnvironmentalEnd, FogRenderDistanceStart, FogRenderDistanceEnd, FogColor);
}