/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.advancements.RaidDenCriteriaTriggers;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.raids.RaidFeature;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class RaidFeatureTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer, RaidFeature feature) {
        this.trigger(serverPlayer, triggerInstance -> triggerInstance.matches(feature));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<RaidFeature> feature) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)RaidFeature.codec().optionalFieldOf("feature").forGetter(TriggerInstance::feature)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(RaidFeature feature) {
            if (!ModCompat.MEGA_SHOWDOWN.isLoaded()) {
                return false;
            }
            return this.feature.isPresent() && this.feature.get() == feature;
        }

        public static Criterion<TriggerInstance> feature(RaidFeature feature) {
            return ((RaidFeatureTrigger)((Object)RaidDenCriteriaTriggers.RAID_FEATURE.value())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(feature)));
        }
    }
}

