/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.commands;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.necro.raid.dens.common.commands.RaidDenCommands;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.util.RaidRegistry;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RaidSpawnCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"crd").then(((LiteralArgumentBuilder)Commands.literal((String)"spawnboss").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).then(Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).then(Commands.literal((String)"boss").then(((RequiredArgumentBuilder)Commands.argument((String)"boss", (ArgumentType)ResourceLocationArgument.id()).suggests(RaidDenCommands.RAID_BOSSES).executes(context -> RaidSpawnCommands.spawnBoss(Vec3Argument.getVec3((CommandContext)context, (String)"pos"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), true, true))).then(((RequiredArgumentBuilder)Commands.argument((String)"noAI", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss(Vec3Argument.getVec3((CommandContext)context, (String)"pos"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), true))).then(Commands.argument((String)"isInvulnerable", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss(Vec3Argument.getVec3((CommandContext)context, (String)"pos"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), BoolArgumentType.getBool((CommandContext)context, (String)"isInvulnerable"))))))))).requires(CommandSourceStack::isPlayer)).then(Commands.literal((String)"boss").then(((RequiredArgumentBuilder)Commands.argument((String)"boss", (ArgumentType)ResourceLocationArgument.id()).suggests(RaidDenCommands.RAID_BOSSES).executes(context -> RaidSpawnCommands.spawnBoss((CommandContext<CommandSourceStack>)context, Vec3Argument.getVec3((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), true, true))).then(((RequiredArgumentBuilder)Commands.argument((String)"noAI", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss((CommandContext<CommandSourceStack>)context, Vec3Argument.getVec3((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), true))).then(Commands.argument((String)"isInvulnerable", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidSpawnCommands.spawnBoss((CommandContext<CommandSourceStack>)context, Vec3Argument.getVec3((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), BoolArgumentType.getBool((CommandContext)context, (String)"noAI"), BoolArgumentType.getBool((CommandContext)context, (String)"isInvulnerable"))))))))));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        RaidSpawnCommands.register(dispatcher);
    }

    private static int spawnBoss(CommandContext<CommandSourceStack> context, Vec3 vec3, ResourceLocation boss, boolean noAI, boolean isInvulnerable) {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (player == null) {
            return 0;
        }
        return RaidSpawnCommands.spawnBoss(vec3, player.serverLevel(), boss, noAI, isInvulnerable);
    }

    private static int spawnBoss(Vec3 vec3, ServerLevel dimension, ResourceLocation boss, boolean noAI, boolean isInvulnerable) {
        if (RaidUtils.isCustomDimension((Level)dimension)) {
            return 0;
        }
        RaidBoss raidBoss = RaidRegistry.getRaidBoss(boss);
        if (raidBoss == null) {
            return 0;
        }
        PokemonEntity pokemonEntity = raidBoss.getBossEntity(dimension);
        if (noAI) {
            pokemonEntity.setNoAi(true);
        }
        if (isInvulnerable) {
            pokemonEntity.setInvulnerable(true);
        }
        pokemonEntity.moveTo(vec3);
        dimension.addFreshEntity((Entity)pokemonEntity);
        return 1;
    }
}

