/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.compat.megashowdown;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.block.MegaShowdownBlocks;
import com.github.yajatkaul.mega_showdown.item.MegaShowdownItems;
import com.github.yajatkaul.mega_showdown.sound.MegaShowdownSounds;
import com.github.yajatkaul.mega_showdown.utils.GlowHandler;
import com.necro.raid.dens.common.raids.RaidType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public abstract class RaidDensMSDCompat {
    public static void setupTera(PokemonEntity pokemonEntity, Pokemon pokemon) {
        Vec3 entityPos = pokemonEntity.position();
        pokemonEntity.level().playSound(null, entityPos.x(), entityPos.y(), entityPos.z(), (SoundEvent)MegaShowdownSounds.TERASTALLIZATION.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
        pokemon.getPersistentData().putBoolean("is_tera", true);
        GlowHandler.applyTeraGlow((PokemonEntity)pokemonEntity);
    }

    public static void setupDmax(PokemonEntity pokemonEntity) {
        Vec3 entityPos = pokemonEntity.position();
        pokemonEntity.level().playSound(null, entityPos.x(), entityPos.y(), entityPos.z(), (SoundEvent)MegaShowdownSounds.DYNAMAX.get(), SoundSource.PLAYERS, 0.4f, 0.5f + (float)Math.random() * 0.5f);
        GlowHandler.applyDynamaxGlow((PokemonEntity)pokemonEntity);
    }

    public static ItemStack getTeraShard(RaidType raidType) {
        return switch (raidType) {
            case RaidType.FIGHTING -> ((Item)MegaShowdownItems.FIGHTING_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FLYING -> ((Item)MegaShowdownItems.FLYING_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.POISON -> ((Item)MegaShowdownItems.POISON_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GROUND -> ((Item)MegaShowdownItems.GROUND_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ROCK -> ((Item)MegaShowdownItems.ROCK_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.BUG -> ((Item)MegaShowdownItems.BUG_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GHOST -> ((Item)MegaShowdownItems.GHOST_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.STEEL -> ((Item)MegaShowdownItems.STEEL_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FIRE -> ((Item)MegaShowdownItems.FIRE_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.WATER -> ((Item)MegaShowdownItems.WATER_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GRASS -> ((Item)MegaShowdownItems.GRASS_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ELECTRIC -> ((Item)MegaShowdownItems.ELECTRIC_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.PSYCHIC -> ((Item)MegaShowdownItems.PSYCHIC_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ICE -> ((Item)MegaShowdownItems.ICE_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.DRAGON -> ((Item)MegaShowdownItems.DRAGON_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.DARK -> ((Item)MegaShowdownItems.DARK_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FAIRY -> ((Item)MegaShowdownItems.FAIRY_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.STELLAR -> ((Item)MegaShowdownItems.STELLAR_TERA_SHARD.get()).getDefaultInstance();
            default -> ((Item)MegaShowdownItems.NORMAL_TERA_SHARD.get()).getDefaultInstance();
        };
    }

    public static ItemStack getMaxMushroom() {
        return ((Block)MegaShowdownBlocks.MAX_MUSHROOM.get()).asItem().getDefaultInstance();
    }
}

