/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.items.item;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.battle.SimpleBagItemLike;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.showdown.bagitems.CheerBagItem;
import com.necro.raid.dens.common.util.IRaidAccessor;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CheerItem
extends Item
implements SimpleBagItemLike {
    private final CheerBagItem.CheerType cheerType;
    private final BagItem bagItem;

    private CheerItem(CheerBagItem.CheerType cheerType, BagItem bagItem) {
        super(new Item.Properties().rarity(Rarity.RARE));
        this.cheerType = cheerType;
        this.bagItem = bagItem;
    }

    public CheerItem(CheerBagItem.CheerType cheerType, int data) {
        this(cheerType, new CheerBagItem(cheerType, data));
    }

    public CheerItem(CheerBagItem.CheerType cheerType, double data) {
        this(cheerType, new CheerBagItem(cheerType, data));
    }

    @NotNull
    public BagItem getBagItem() {
        return this.bagItem;
    }

    public boolean handleInteraction(@NotNull ServerPlayer player, @NotNull BattlePokemon battlePokemon, @NotNull ItemStack stack) {
        PokemonBattle battle = battlePokemon.getActor().getBattle();
        BattlePokemon raidPokemon = ((ActiveBattlePokemon)battle.getSide2().getActivePokemon().getFirst()).getBattlePokemon();
        if (raidPokemon == null || raidPokemon.getEntity() == null || !((IRaidAccessor)raidPokemon.getEntity()).isRaidBoss()) {
            return false;
        }
        BagItem bagItem = this.getBagItem(stack);
        if (bagItem == null) {
            return false;
        }
        if (!battlePokemon.getActor().canFitForcedAction()) {
            player.sendSystemMessage((Component)LocalizationUtilsKt.battleLang((String)"bagitem.cannot", (Object[])new Object[0]).withStyle(ChatFormatting.RED));
            return false;
        }
        if (!bagItem.canUse(stack, battle, battlePokemon)) {
            player.sendSystemMessage((Component)LocalizationUtilsKt.battleLang((String)"bagitem.invalid", (Object[])new Object[0]).withStyle(ChatFormatting.RED));
            return false;
        }
        UUID raidId = ((IRaidAccessor)raidPokemon.getEntity()).getRaidId();
        String data = player.getName().getString();
        RaidInstance raid = RaidHelper.ACTIVE_RAIDS.get(raidId);
        if (!raid.runCheer(player, battle, this.getBagItem(), data)) {
            player.sendSystemMessage((Component)Component.translatable((String)"battle.cobblemonraiddens.cheer.cannot").withStyle(ChatFormatting.RED));
            return false;
        }
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (!level.isClientSide()) {
            PokemonBattle battle = BattleRegistry.getBattleByParticipatingPlayer((ServerPlayer)((ServerPlayer)player));
            if (battle == null) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            BattlePokemon battlePokemon = ((ActiveBattlePokemon)battle.getSide1().getActivePokemon().getFirst()).getBattlePokemon();
            BattlePokemon raidPokemon = ((ActiveBattlePokemon)battle.getSide2().getActivePokemon().getFirst()).getBattlePokemon();
            if (battlePokemon == null || raidPokemon == null) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            if (raidPokemon.getEntity() == null || !((IRaidAccessor)raidPokemon.getEntity()).isRaidBoss()) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            boolean success = this.handleInteraction((ServerPlayer)player, battlePokemon, itemStack);
            if (!success) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            itemStack.consume(1, (LivingEntity)player);
            CriteriaTriggers.CONSUME_ITEM.trigger((ServerPlayer)player, itemStack);
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.cobblemonraiddens.cheer.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)String.format("item.cobblemonraiddens.%s.tooltip", this.cheerType.getId())).withStyle(ChatFormatting.GRAY));
    }
}

