/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.loot.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.megashowdown.RaidDensMSDCompat;
import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.loot.LootFunctions;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.jetbrains.annotations.NotNull;

public class TeraShardsFunction
extends LootItemConditionalFunction {
    public static final MapCodec<TeraShardsFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> TeraShardsFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, TeraShardsFunction::new));

    protected TeraShardsFunction(List<LootItemCondition> list) {
        super(list);
    }

    @NotNull
    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)LootFunctions.TERA_SHARDS_FUNCTION.value();
    }

    @NotNull
    protected ItemStack run(@NotNull ItemStack itemStack, @NotNull LootContext lootContext) {
        int count;
        if (!ModCompat.MEGA_SHOWDOWN.isLoaded()) {
            return itemStack;
        }
        Entity entity = (Entity)lootContext.getParamOrNull(LootContextParams.THIS_ENTITY);
        if (!(entity instanceof LivingEntity)) {
            return itemStack;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack heldItem = livingEntity.getMainHandItem();
        if (!heldItem.has((DataComponentType)ModComponents.TIER_COMPONENT.value())) {
            return itemStack;
        }
        RaidTier raidTier = (RaidTier)((Object)heldItem.get((DataComponentType)ModComponents.TIER_COMPONENT.value()));
        if (!heldItem.has((DataComponentType)ModComponents.TYPE_COMPONENT.value())) {
            return itemStack;
        }
        RaidType raidType = (RaidType)((Object)heldItem.get((DataComponentType)ModComponents.TYPE_COMPONENT.value()));
        assert (raidTier != null && raidType != null);
        if (raidType == RaidType.NONE) {
            return itemStack;
        }
        switch (raidTier) {
            case TIER_ONE: 
            case TIER_TWO: {
                int n = lootContext.getRandom().nextIntBetweenInclusive(1, 3);
                break;
            }
            case TIER_THREE: 
            case TIER_FOUR: {
                int n = lootContext.getRandom().nextIntBetweenInclusive(2, 5);
                break;
            }
            case TIER_FIVE: {
                int n = lootContext.getRandom().nextIntBetweenInclusive(5, 10);
                break;
            }
            case TIER_SIX: {
                int n = lootContext.getRandom().nextIntBetweenInclusive(10, 20);
                break;
            }
            default: {
                int n = count = 30;
            }
        }
        if (count == 0) {
            return itemStack;
        }
        itemStack = RaidDensMSDCompat.getTeraShard(raidType);
        itemStack.setCount(count);
        return itemStack;
    }

    public static LootItemConditionalFunction.Builder<?> apply() {
        return TeraShardsFunction.simpleBuilder(TeraShardsFunction::new);
    }
}

