/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.showdown;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.Effect;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.pokemon.status.Status;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.battles.dispatch.ActionEffectInstruction;
import com.cobblemon.mod.common.battles.dispatch.CauserInstruction;
import com.cobblemon.mod.common.battles.dispatch.DispatchResultKt;
import com.cobblemon.mod.common.battles.dispatch.InstructionSet;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.dispatch.UntilDispatch;
import com.cobblemon.mod.common.battles.interpreter.instructions.DamageInstruction;
import com.cobblemon.mod.common.battles.interpreter.instructions.MoveInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DamageInstruction.class})
public abstract class DamageInstructionMixin
implements ActionEffectInstruction {
    @Final
    @Shadow(remap=false)
    private BattleMessage publicMessage;
    @Final
    @Shadow(remap=false)
    private BattleMessage privateMessage;
    @Final
    @Shadow(remap=false)
    private InstructionSet instructionSet;
    @Final
    @Shadow(remap=false)
    private BattleActor actor;

    @Inject(method={"postActionEffect(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void postActionEffectInject(PokemonBattle battle, CallbackInfo ci) {
        if (!((IRaidBattle)battle).isRaidBattle()) {
            return;
        }
        RaidInstance raidInstance = ((IRaidBattle)battle).getRaidBattle();
        BattlePokemon battlePokemon = this.publicMessage.battlePokemon(0, this.actor.battle);
        if (battlePokemon == null || battlePokemon.getEntity() == null) {
            return;
        }
        if (!((IRaidAccessor)battlePokemon.getEntity()).isRaidBoss()) {
            return;
        }
        String args = this.privateMessage.argumentAt(1);
        assert (args != null);
        String newHealth = args.split(" ")[0];
        CauserInstruction lastCauser = this.instructionSet.getMostRecentCauser((InterpreterInstruction)this);
        boolean causedFaint = newHealth.equals("0");
        Effect effect = this.privateMessage.effect("from");
        battle.dispatch(() -> {
            MutableComponent pokemonName = battlePokemon.getName();
            BattlePokemon source = this.privateMessage.battlePokemonFromOptional(battle, "of");
            if (effect != null) {
                MutableComponent lang = null;
                if (Set.of("brn", "psn", "tox").contains(effect.getId())) {
                    Status status = Statuses.getStatus((String)effect.getId());
                    if (status != null) {
                        lang = LocalizationUtilsKt.battleLang((String)String.format("status.%s.hurt", status.getName().getPath()), (Object[])new Object[]{pokemonName});
                    }
                } else {
                    lang = Set.of("aftermath", "innardsout").contains(effect.getId()) ? LocalizationUtilsKt.battleLang((String)"damage.generic", (Object[])new Object[]{pokemonName}) : (Set.of("chloroblast", "steelbeam").contains(effect.getId()) ? LocalizationUtilsKt.battleLang((String)"damage.mindblown", (Object[])new Object[]{pokemonName}) : (effect.getId().equals("jumpkick") ? LocalizationUtilsKt.battleLang((String)"damage.highjumpkick", (Object[])new Object[]{pokemonName}) : LocalizationUtilsKt.battleLang((String)("damage." + effect.getId()), (Object[])new Object[]{pokemonName, source != null ? source.getName() : Component.literal((String)"UNKOWN")})));
                }
                if (lang != null) {
                    battle.broadcastChatMessage(lang);
                }
            }
            if (causedFaint) {
                battlePokemon.getEffectedPokemon().setCurrentHealth(0);
                raidInstance.queueStopRaid();
            } else {
                float remainingHealth = Float.parseFloat(newHealth.split("/")[0]);
                ServerPlayer player = (ServerPlayer)battle.getPlayers().getFirst();
                raidInstance.syncHealth(player, battle, remainingHealth);
                battlePokemon.getEffectedPokemon().setCurrentHealth((int)raidInstance.getRemainingHealth());
            }
            if (lastCauser instanceof MoveInstruction && ((MoveInstruction)lastCauser).getActionEffect() != null && !causedFaint) {
                return new UntilDispatch(() -> ((MoveInstruction)lastCauser).getFuture().isDone());
            }
            if (causedFaint) {
                return DispatchResultKt.getGO();
            }
            return new UntilDispatch(() -> !this.getHolds().contains("effects"));
        });
        ci.cancel();
    }
}

