/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.blocks.entity.RaidHomeBlockEntity;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class RaidExitHelper {
    private static final Set<UUID> RECENT_DEATHS = new HashSet<UUID>();

    public static void afterRespawn(ServerPlayer player) {
        RECENT_DEATHS.add(player.getUUID());
    }

    public static void afterRespawn(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean alive) {
        RaidExitHelper.afterRespawn(newPlayer);
    }

    public static void onDimensionChange(ServerPlayer player, ResourceKey<Level> from, ResourceKey<Level> to) {
        if (player.getServer() == null) {
            return;
        }
        ServerLevel fromLevel = player.getServer().getLevel(from);
        if (fromLevel == null) {
            return;
        }
        RaidExitHelper.onDimensionChange(player, fromLevel);
    }

    public static void onDimensionChange(ServerPlayer player, ServerLevel from, ServerLevel to) {
        RaidExitHelper.onDimensionChange(player, from);
    }

    private static void onDimensionChange(ServerPlayer player, ServerLevel from) {
        if (!RaidUtils.isCustomDimension((Level)from)) {
            return;
        }
        if (RECENT_DEATHS.remove(player.getUUID())) {
            return;
        }
        BlockEntity blockEntity = from.getBlockEntity(BlockPos.ZERO);
        if (!(blockEntity instanceof RaidHomeBlockEntity)) {
            return;
        }
        RaidHomeBlockEntity homeBlock = (RaidHomeBlockEntity)blockEntity;
        if (homeBlock.getHomePos() == null || player.getServer() == null) {
            return;
        }
        ServerLevel home = player.getServer().getLevel(homeBlock.getHome());
        if (home == null) {
            return;
        }
        BlockEntity blockEntity2 = home.getBlockEntity(homeBlock.getHomePos());
        if (blockEntity2 instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystalBlockEntity = (RaidCrystalBlockEntity)blockEntity2;
            if (from.getEntitiesOfClass(LivingEntity.class, new AABB(BlockPos.ZERO).inflate(48.0), RaidExitHelper::isAlive).isEmpty()) {
                raidCrystalBlockEntity.clearRaid();
            } else if (from.getEntitiesOfClass(Player.class, new AABB(BlockPos.ZERO).inflate(48.0)).isEmpty()) {
                raidCrystalBlockEntity.setQueueClose();
            }
            raidCrystalBlockEntity.addChunkTicket();
            raidCrystalBlockEntity.addChunkTicket(BlockPos.containing((Position)RaidDenRegistry.getBossPos(raidCrystalBlockEntity.getRaidStructure())), from);
        }
        RaidDenNetworkMessages.JOIN_RAID.accept(player, false);
    }

    private static boolean isAlive(LivingEntity entity) {
        return entity != null && entity.isAlive();
    }
}

