/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.advancements.RaidDenCriteriaTriggers;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.cobbledollars.RaidDensCobbleDollarsCompat;
import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RewardPokemonEvent;
import com.necro.raid.dens.common.items.ModItems;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidHelper;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RewardHandler {
    private final RaidBoss raidBoss;
    private final ServerPlayer player;
    private final boolean isCatchable;
    private final Pokemon cachedReward;

    public RewardHandler(RaidBoss raidBoss, ServerPlayer player, boolean isCatchable, Pokemon cachedReward) {
        this.raidBoss = raidBoss;
        this.player = player;
        this.isCatchable = isCatchable;
        this.cachedReward = cachedReward;
    }

    public RewardHandler(RaidBoss raidBoss, ServerPlayer player, boolean isCatchable) {
        this(raidBoss, player, isCatchable, null);
    }

    public void sendRewardMessage() {
        if (this.raidBoss.getDisplaySpecies() == null) {
            this.raidBoss.createDisplayAspects();
        }
        String speciesName = ((TranslatableContents)this.raidBoss.getDisplaySpecies().getTranslatedName().getContents()).getKey();
        RaidDenNetworkMessages.REWARD_PACKET.accept((Object)this.player, (Object)this.isCatchable, (Object)speciesName);
        RaidHelper.REWARD_QUEUE.put(this.player.getUUID(), this);
    }

    public boolean givePokemonToPlayer() {
        Item item = this.player.getMainHandItem().getItem();
        if (!(item instanceof PokeBallItem)) {
            this.player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.reward.reward_not_pokeball"));
            return false;
        }
        PokeBallItem pokeBallItem = (PokeBallItem)item;
        Pokemon pokemon = this.cachedReward == null ? this.raidBoss.getRewardPokemon(this.player) : this.cachedReward;
        pokemon.setCaughtBall(pokeBallItem.getPokeBall());
        if (!RaidEvents.REWARD_POKEMON.postWithResult(new RewardPokemonEvent(this.player, pokemon))) {
            return false;
        }
        if (!this.giveItemToPlayer()) {
            return false;
        }
        PlayerExtensionsKt.party((ServerPlayer)this.player).add(pokemon);
        this.player.getMainHandItem().consume(1, (LivingEntity)this.player);
        RaidDenCriteriaTriggers.triggerRaidShiny(this.player, pokemon);
        return true;
    }

    public boolean giveItemToPlayer() {
        ItemStack raidPouch = this.buildRaidPouch();
        List<ItemStack> rewards = this.raidBoss.getRandomRewards(this.player.serverLevel());
        rewards.addFirst(raidPouch);
        for (ItemStack item : rewards) {
            ItemEntity itemEntity;
            if (this.player.getInventory().add(item) || (itemEntity = this.player.drop(item, false)) == null) continue;
            itemEntity.setNoPickUpDelay();
            itemEntity.setTarget(this.player.getUUID());
        }
        return true;
    }

    public void giveCurrency() {
        if (!ModCompat.COBBLEDOLLARS.isLoaded()) {
            return;
        }
        if (this.raidBoss.getCurrency() <= 0) {
            return;
        }
        RaidDensCobbleDollarsCompat.addCurrency(this.player, this.raidBoss.getCurrency());
    }

    private ItemStack buildRaidPouch() {
        ItemStack item = ((Item)ModItems.RAID_POUCH.value()).getDefaultInstance();
        item.set((DataComponentType)ModComponents.TIER_COMPONENT.value(), (Object)this.raidBoss.getTier());
        item.set((DataComponentType)ModComponents.FEATURE_COMPONENT.value(), (Object)this.raidBoss.getFeature());
        item.set((DataComponentType)ModComponents.TYPE_COMPONENT.value(), (Object)this.raidBoss.getType());
        return item;
    }
}

