/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.neoforge.events;

import com.necro.raid.dens.common.dimensions.DimensionHelper;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidExitHelper;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import com.necro.raid.dens.common.util.RaidRegistry;
import com.necro.raid.dens.common.util.RaidUtils;
import com.necro.raid.dens.neoforge.events.reloader.BossAdditionsReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidBossReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidBucketReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidDenPoolReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidTagReloadListener;
import com.necro.raid.dens.neoforge.events.reloader.RaidTemplateReloadListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="cobblemonraiddens")
public class ModEvents {
    @SubscribeEvent
    public static void commonTick(ServerTickEvent.Post event) {
        RaidHelper.commonTick();
        DimensionHelper.removePending(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (RaidHelper.isAlreadyHosting((Player)player2) || RaidHelper.isAlreadyParticipating((Player)player2) || RaidHelper.JOIN_QUEUE.containsKey(player2)) {
            RaidDenNetworkMessages.JOIN_RAID.accept(player2, true);
        }
        if (RaidHelper.REWARD_QUEUE.containsKey(player2.getUUID())) {
            RaidHelper.REWARD_QUEUE.get(player2.getUUID()).sendRewardMessage();
        }
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        RaidHelper.onPlayerDisconnect(event.getEntity());
        DimensionHelper.removeDelayed(event.getEntity().getServer(), (ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onServerStart(ServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        RaidHelper.initHelper(server);
        RaidRegistry.initRaidBosses(server);
        RaidBucketRegistry.init(server);
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        DimensionHelper.removeDelayed(event.getServer());
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (RaidUtils.cannotPlace(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (RaidUtils.cannotBreak(event.getPlayer(), (Level)event.getLevel())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onReloadDataPack(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new RaidBossReloadListener());
        event.addListener((PreparableReloadListener)new RaidBucketReloadListener());
        event.addListener((PreparableReloadListener)new RaidDenPoolReloadListener());
        event.addListener((PreparableReloadListener)new RaidTemplateReloadListener());
        event.addListener((PreparableReloadListener)new RaidTagReloadListener());
        event.addListener((PreparableReloadListener)new BossAdditionsReloadListener());
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            RaidExitHelper.onDimensionChange(serverPlayer, (ResourceKey<Level>)event.getFrom(), (ResourceKey<Level>)event.getTo());
        }
    }
}

