/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.client.gui.buttons;

import com.necro.raid.dens.common.client.gui.buttons.AbstractRaidButton;
import com.necro.raid.dens.common.client.keybind.RaidDenKeybinds;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class PopupButton
extends AbstractRaidButton {
    private final int index;

    public PopupButton(int width, int height, int index, ResourceLocation texture, ResourceLocation hover, MutableComponent label, Button.OnPress onPress) {
        super(width, height, texture, hover, label, onPress);
        this.index = index;
    }

    @Override
    protected void render(GuiGraphics guiGraphics, ResourceLocation texture) {
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY(), 4000.0f);
        guiGraphics.blit(texture, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.65f, 0.65f, 1.0f);
        MutableComponent component = this.getMessage().copy().append(this.getFormat());
        guiGraphics.drawCenteredString(minecraft.font, (Component)component, (int)((double)this.width / 1.3), 9, 0xFFFFFF);
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
    }

    private String getFormat() {
        KeyMapping key = this.index == 0 ? RaidDenKeybinds.ACCEPT_SHORTCUT : RaidDenKeybinds.DENY_SHORTCUT;
        String keyName = key.getTranslatedKeyMessage().getString();
        if (key.isUnbound() || keyName.length() > 3) {
            return "";
        }
        return String.format(" [%s]", keyName);
    }
}

