/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.network.packets;

import com.necro.raid.dens.common.client.gui.RaidDenGuiManager;
import com.necro.raid.dens.common.client.gui.screens.RaidOverlay;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record JoinRaidPacket(boolean isJoining) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"join_raid");
    public static final CustomPacketPayload.Type<JoinRaidPacket> PACKET_TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, JoinRaidPacket> CODEC = StreamCodec.ofMember(JoinRaidPacket::write, JoinRaidPacket::read);

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isJoining);
    }

    public static JoinRaidPacket read(FriendlyByteBuf buf) {
        return new JoinRaidPacket(buf.readBoolean());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public void handleClient() {
        RaidDenGuiManager.RAID_OVERLAY = this.isJoining ? new RaidOverlay() : null;
    }
}

