/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.network.packets;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record RaidAspectPacket(int entityId) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_aspect");
    public static final CustomPacketPayload.Type<RaidAspectPacket> PACKET_TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, RaidAspectPacket> CODEC = StreamCodec.ofMember(RaidAspectPacket::write, RaidAspectPacket::read);

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public static RaidAspectPacket read(FriendlyByteBuf buf) {
        return new RaidAspectPacket(buf.readInt());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    public void handleClient() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        Entity entity = level.getEntity(this.entityId);
        if (!(entity instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)entity;
        HashSet<String> aspects = new HashSet<String>(pokemonEntity.getPokemon().getForcedAspects());
        aspects.add("raid");
        pokemonEntity.getPokemon().setForcedAspects(aspects);
        pokemonEntity.refreshDimensions();
    }
}

