/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.battles.model.ai.BattleAI;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.BattleStartError;
import com.cobblemon.mod.common.battles.BattleStartResult;
import com.cobblemon.mod.common.battles.ErroredBattleStart;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.ai.RandomBattleAI;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.CobblemonRaidDens;
import java.util.List;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class RaidBuilder {
    public static BattleStartResult build(ServerPlayer player, PokemonEntity pokemonEntity, @Nullable UUID leadingPokemon) {
        List battleTeam = PlayerExtensionsKt.party((ServerPlayer)player).toBattleTeam(false, false, leadingPokemon);
        if (!battleTeam.isEmpty()) {
            battleTeam = battleTeam.subList(0, Mth.clamp((int)battleTeam.size(), (int)1, (int)CobblemonRaidDens.CONFIG.raid_party_size));
        }
        PlayerBattleActor playerActor = new PlayerBattleActor(player.getUUID(), battleTeam);
        PokemonBattleActor wildActor = new PokemonBattleActor(pokemonEntity.getPokemon().getUuid(), new BattlePokemon(pokemonEntity.getPokemon(), pokemonEntity.getPokemon(), p -> Unit.INSTANCE), Cobblemon.config.getDefaultFleeDistance(), (BattleAI)new RandomBattleAI());
        BattleFormat battleFormat = BattleFormat.Companion.getGEN_9_SINGLES();
        ErroredBattleStart errors = new ErroredBattleStart();
        if (!battleTeam.isEmpty() && ((BattlePokemon)battleTeam.getFirst()).getHealth() <= 0) {
            errors.getParticipantErrors().get((BattleActor)playerActor).add(BattleStartError.Companion.insufficientPokemon((Entity)player, battleFormat.getBattleType().getSlotsPerActor(), playerActor.getPokemonList().size()));
        }
        if (playerActor.getPokemonList().stream().anyMatch(battlePokemon -> battlePokemon.getEntity() != null && battlePokemon.getEntity().isBusy())) {
            player.getDisplayName();
            errors.getParticipantErrors().get((BattleActor)playerActor).add(BattleStartError.Companion.targetIsBusy(player.getDisplayName()));
        }
        if (BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player) != null) {
            errors.getParticipantErrors().get((BattleActor)playerActor).add(BattleStartError.Companion.alreadyInBattle((BattleActor)playerActor));
        }
        playerActor.setBattleTheme(pokemonEntity.getBattleTheme());
        if (errors.isEmpty()) {
            return BattleRegistry.INSTANCE.startBattle(battleFormat, new BattleSide(new BattleActor[]{playerActor}), new BattleSide(new BattleActor[]{wildActor}), true);
        }
        return errors;
    }
}

