/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.block;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RaidJoinEvent;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidCycleMode;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.HashSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RaidCrystalBlock
extends BaseEntityBlock {
    public static final EnumProperty<RaidType> RAID_TYPE = EnumProperty.create((String)"raid_type", RaidType.class);
    public static final EnumProperty<RaidTier> RAID_TIER = EnumProperty.create((String)"raid_tier", RaidTier.class);
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"is_active");
    public static final BooleanProperty CAN_RESET = BooleanProperty.create((String)"can_reset");
    public static final EnumProperty<RaidCycleMode> CYCLE_MODE = EnumProperty.create((String)"cycle_mode", RaidCycleMode.class);

    public RaidCrystalBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue(RAID_TYPE, (Comparable)((Object)RaidType.NONE))).setValue(RAID_TIER, (Comparable)((Object)RaidTier.TIER_ONE))).setValue((Property)CAN_RESET, (Comparable)Boolean.valueOf(false))).setValue(CYCLE_MODE, (Comparable)((Object)RaidCycleMode.NONE)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        Boolean success = this.startOrJoinRaid(player, blockState, (RaidCrystalBlockEntity)level.getBlockEntity(blockPos), null);
        if (success == null || success.booleanValue()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (CobblemonRaidDens.CONFIG.requires_key && !RaidUtils.isRaidDenKey(itemStack)) {
            return ItemInteractionResult.FAIL;
        }
        if (level.isClientSide()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!CobblemonRaidDens.CONFIG.requires_key) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Boolean success = this.startOrJoinRaid(player, blockState, (RaidCrystalBlockEntity)level.getBlockEntity(blockPos), itemStack);
        if (success == null) {
            return ItemInteractionResult.SUCCESS;
        }
        if (success.booleanValue()) {
            itemStack.consume(1, (LivingEntity)player);
        } else {
            player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.no_key"));
        }
        return success != false ? ItemInteractionResult.CONSUME : ItemInteractionResult.FAIL;
    }

    private Boolean startOrJoinRaid(Player player, BlockState blockState, RaidCrystalBlockEntity blockEntity, @Nullable ItemStack key) {
        if (blockEntity.isBusy() || player.getServer() == null) {
            return false;
        }
        if (!blockEntity.isActive(blockState) || blockEntity.isAtMaxClears()) {
            player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.is_not_active"));
            return false;
        }
        if (RaidHelper.hasClearedRaid(blockEntity.getUuid(), player)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.player_cleared"));
            return false;
        }
        if (blockEntity.hasDimension() && blockEntity.isPlayerParticipating(player)) {
            Vec3 playerPos = RaidDenRegistry.getPlayerPos(blockEntity.getRaidStructure());
            ChunkPos pos = new ChunkPos(BlockPos.containing((Position)playerPos));
            blockEntity.getDimension().getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, pos, 1, (Object)player.getId());
            player.getServer().execute(() -> player.teleportTo(blockEntity.getDimension(), playerPos.x, playerPos.y, playerPos.z, new HashSet(), 180.0f, 0.0f));
            return null;
        }
        if (RaidHelper.isAlreadyHosting(player)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.already_hosting"));
            return false;
        }
        if (RaidHelper.isAlreadyParticipating(player)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.already_participating"));
            return false;
        }
        if (blockEntity.canSetRaidHost()) {
            boolean success = this.startRaid(player, blockEntity);
            if (!success) {
                blockEntity.clearRaidHost();
            }
            return success;
        }
        if (blockEntity.isFull()) {
            player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.lobby_is_full"));
            return false;
        }
        if (RaidHelper.isInQueue(player)) {
            player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.already_in_queue"));
            return false;
        }
        return this.requestJoinRaid(player, blockEntity, key);
    }

    private boolean requestJoinRaid(Player player, RaidCrystalBlockEntity blockEntity, @Nullable ItemStack key) {
        MinecraftServer server = player.getServer();
        if (server == null) {
            return false;
        }
        ServerPlayer raidHost = server.getPlayerList().getPlayer(blockEntity.getRaidHost());
        if (raidHost == null) {
            player.sendSystemMessage(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.no_host"));
            return false;
        }
        RaidHelper.addToQueue(player, key);
        RaidHelper.addRequest(raidHost, player, blockEntity);
        RaidDenNetworkMessages.REQUEST_PACKET.accept(raidHost, player.getName().getString());
        return true;
    }

    private boolean startRaid(Player player, RaidCrystalBlockEntity blockEntity) {
        ServerLevel level;
        if (blockEntity.getLevel() == null || player.getServer() == null) {
            return false;
        }
        blockEntity.setRaidHost(player);
        try {
            level = this.getOrCreateDimension(blockEntity);
        }
        catch (IllegalStateException e) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.already_hosting").withStyle(ChatFormatting.RED));
            return false;
        }
        boolean success = RaidEvents.RAID_JOIN.postWithResult(new RaidJoinEvent((ServerPlayer)player, true, blockEntity.getRaidBoss()));
        if (!success) {
            return false;
        }
        blockEntity.setDimension(level);
        if (!blockEntity.spawnRaidBoss()) {
            blockEntity.setQueueClose();
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.boss_spawn_failed").withStyle(ChatFormatting.RED));
            return false;
        }
        RaidHelper.addHost(player);
        blockEntity.getLevel().getChunkAt(blockEntity.getBlockPos()).setUnsaved(true);
        Vec3 playerPos = RaidDenRegistry.getPlayerPos(blockEntity.getRaidStructure());
        ChunkPos pos = new ChunkPos(BlockPos.containing((Position)playerPos));
        blockEntity.getDimension().getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, pos, 1, (Object)player.getId());
        player.getServer().execute(() -> player.teleportTo(blockEntity.getDimension(), playerPos.x, playerPos.y, playerPos.z, new HashSet(), 180.0f, 0.0f));
        return true;
    }

    private ServerLevel getOrCreateDimension(RaidCrystalBlockEntity blockEntity) {
        return blockEntity.getDimension() != null ? blockEntity.getDimension() : this.createDimension(blockEntity);
    }

    protected abstract ServerLevel createDimension(RaidCrystalBlockEntity var1);

    protected void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(blockPos)) instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity blockEntity2 = (RaidCrystalBlockEntity)blockEntity;
            blockEntity2.closeRaid(blockPos);
            RaidHelper.resetClearedRaids(blockEntity2.getUuid());
        }
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{RAID_TYPE});
        builder.add(new Property[]{RAID_TIER});
        builder.add(new Property[]{ACTIVE});
        builder.add(new Property[]{CAN_RESET});
        builder.add(new Property[]{CYCLE_MODE});
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return null;
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }
}

