/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.entity;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.ModBlocks;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidHomeBlockEntity;
import com.necro.raid.dens.common.dimensions.DimensionHelper;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidCycleMode;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.RaidBucket;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class RaidCrystalBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private UUID raidHost;
    private final Set<UUID> playerQueue;
    private int clears;
    private int inactiveTicks;
    private int soundTicks = 0;
    private UUID uuid;
    private ResourceLocation raidBucket;
    private ResourceLocation raidBoss;
    private ServerLevel dimension;
    private ResourceLocation raidStructure;
    private boolean queueFindDimension = false;
    private int queueTimeout = 0;
    private boolean queueClose = false;
    private long lastReset;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RaidCrystalBlockEntity(BlockEntityType<? extends RaidCrystalBlockEntity> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.playerQueue = new HashSet<UUID>();
        this.uuid = UUID.randomUUID();
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (this.queueFindDimension && this.raidHost != null && level.getServer() != null) {
            this.dimension = level.getServer().getLevel(ModDimensions.createLevelKey(this.raidHost.toString()));
            if (this.hasDimension()) {
                this.queueFindDimension = false;
            } else {
                ++this.queueTimeout;
            }
            if (this.queueTimeout > 200) {
                RaidHelper.removeHost(this.raidHost);
                RaidHelper.finishRaid(this.playerQueue);
                this.raidHost = null;
                this.playerQueue.clear();
                this.queueFindDimension = false;
            }
        } else if (this.queueClose && (this.dimension == null || this.dimension.players().isEmpty())) {
            this.closeRaid(blockPos);
            if (this.isAtMaxClears()) {
                level.setBlock(blockPos, (BlockState)blockState.setValue((Property)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
            }
            this.queueClose = false;
        }
        if (level.isClientSide()) {
            return;
        }
        if (!this.canTick(blockState)) {
            return;
        }
        if (this.raidBoss == null || !RaidRegistry.exists(this.raidBoss)) {
            this.generateRaidBoss(level, blockPos, blockState);
        }
        if (++this.soundTicks % 60 == 0) {
            level.playSound(null, blockPos, SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.soundTicks = 0;
        }
        if (this.raidHost != null && this.hasDimension() && this.dimension.players().isEmpty()) {
            if (++this.inactiveTicks > 2400) {
                this.closeRaid(blockPos);
            }
        } else {
            this.inactiveTicks = 0;
        }
        if (!((Boolean)blockState.getValue((Property)RaidCrystalBlock.CAN_RESET)).booleanValue()) {
            return;
        }
        if (CobblemonRaidDens.CONFIG.reset_time <= 0) {
            return;
        }
        if (this.isInProgress()) {
            return;
        }
        long gameTime = level.getGameTime();
        if (this.lastReset == 0L) {
            this.lastReset = gameTime;
        } else if (gameTime - this.lastReset > (long)CobblemonRaidDens.CONFIG.reset_time * 20L) {
            this.playerQueue.clear();
            this.generateRaidBoss(level, blockPos, blockState);
        }
    }

    public void generateRaidBoss(Level level, BlockPos blockPos, BlockState blockState) {
        RaidCycleMode cycleMode = (RaidCycleMode)((Object)blockState.getValue(RaidCrystalBlock.CYCLE_MODE));
        ResourceLocation bossLocation = null;
        if (cycleMode == RaidCycleMode.NONE) {
            return;
        }
        if (this.raidBucket != null) {
            bossLocation = RaidBucketRegistry.getBucket(this.raidBucket).getRandomRaidBoss(level.getRandom(), level);
        }
        if (bossLocation == null) {
            RaidTier tier = cycleMode.canCycleTier() ? RaidTier.getWeightedRandom(level.getRandom(), level) : (RaidTier)((Object)blockState.getValue(RaidCrystalBlock.RAID_TIER));
            RaidType type = cycleMode.canCycleType() ? null : (RaidType)((Object)blockState.getValue(RaidCrystalBlock.RAID_TYPE));
            bossLocation = RaidRegistry.getRandomRaidBoss(level.getRandom(), level, tier, type, null);
        }
        RaidBoss raidBoss = RaidRegistry.getRaidBoss(bossLocation);
        if (bossLocation == null || raidBoss == null) {
            return;
        }
        this.setRaidBoss(bossLocation, level.getRandom(), level.getGameTime());
        level.setBlock(blockPos, (BlockState)((BlockState)((BlockState)blockState.setValue(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier()))).setValue(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).setValue((Property)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
    }

    public boolean spawnRaidBoss() {
        if (this.dimension == null) {
            return false;
        }
        RaidBoss raidBoss = this.getRaidBoss();
        if (raidBoss == null) {
            CobblemonRaidDens.LOGGER.error("Could not load Raid Boss {}", (Object)this.raidBoss);
            this.setRaidBoss(null, null, 0L);
            return false;
        }
        StructureTemplateManager structureManager = this.dimension.getStructureManager();
        StructureTemplate template = structureManager.get(this.getRaidStructure()).orElseGet(() -> {
            this.raidStructure = RaidDenRegistry.DEFAULT;
            return structureManager.getOrCreate(this.getRaidStructure());
        });
        StructurePlaceSettings settings = new StructurePlaceSettings();
        Vec3 offset = RaidDenRegistry.getOffset(this.getRaidStructure());
        BlockPos corner = BlockPos.containing((Position)offset);
        template.placeInWorld((ServerLevelAccessor)this.dimension, corner, corner, settings, this.dimension.getRandom(), 2);
        this.dimension.setBlockAndUpdate(BlockPos.ZERO, ModBlocks.INSTANCE.getRaidHomeBlock().defaultBlockState());
        BlockEntity blockEntity = this.dimension.getBlockEntity(BlockPos.ZERO);
        if (blockEntity instanceof RaidHomeBlockEntity) {
            RaidHomeBlockEntity homeBlockEntity = (RaidHomeBlockEntity)blockEntity;
            homeBlockEntity.setHome(this.getBlockPos(), (ServerLevel)this.getLevel());
        }
        PokemonEntity pokemonEntity = raidBoss.getBossEntity(this.dimension);
        pokemonEntity.moveTo(RaidDenRegistry.getBossPos(this.getRaidStructure()));
        this.dimension.addFreshEntity((Entity)pokemonEntity);
        return true;
    }

    public void clearRaid() {
        ++this.clears;
        if (this.isAtMaxClears()) {
            RaidHelper.resetClearedRaids(this.getUuid());
        } else {
            RaidHelper.clearRaid(this.getUuid(), this.playerQueue);
        }
        this.setQueueClose();
    }

    public void closeRaid(BlockPos blockPos) {
        RaidHelper.removeHost(this.raidHost);
        RaidHelper.finishRaid(this.playerQueue);
        if (this.getLevel() == null) {
            return;
        }
        MinecraftServer server = this.getLevel().getServer();
        ServerPlayer p = null;
        if (server != null && this.raidHost != null) {
            p = server.getPlayerList().getPlayer(this.raidHost);
        }
        if (p != null) {
            server.getCommands().sendCommands(p);
        }
        if (!this.hasDimension()) {
            return;
        }
        this.dimension.players().forEach(player -> player.teleportTo((ServerLevel)this.getLevel(), (double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() - 0.5, 0.0f, 0.0f));
        this.dimension.getEntitiesOfClass(PokemonEntity.class, new AABB(BlockPos.ZERO).inflate(32.0), p1 -> ((IRaidAccessor)p1).isRaidBoss()).forEach(p1 -> {
            RaidInstance raidInstance = RaidHelper.ACTIVE_RAIDS.remove(((IRaidAccessor)p1).getRaidId());
            if (raidInstance != null) {
                raidInstance.stopRaid(false);
            }
        });
        this.removeDimension();
        this.dimension = null;
        this.raidHost = null;
        this.playerQueue.clear();
        this.inactiveTicks = 0;
        this.getLevel().getChunkAt(blockPos).setUnsaved(true);
        this.setChanged();
    }

    protected void removeDimension() {
        ResourceKey<Level> levelKey = ModDimensions.createLevelKey(this.raidHost.toString());
        DimensionHelper.queueForRemoval(levelKey, this.dimension);
        if (this.getLevel() != null) {
            DimensionHelper.SYNC_DIMENSIONS.accept((Object)this.getLevel().getServer(), levelKey, (Object)false);
        }
    }

    public UUID getRaidHost() {
        return this.raidHost;
    }

    public boolean canSetRaidHost() {
        return this.getRaidHost() == null;
    }

    public void setRaidHost(Player player) {
        this.raidHost = player.getUUID();
        this.playerQueue.add(player.getUUID());
        this.setChanged();
    }

    public void clearRaidHost() {
        this.playerQueue.remove(this.raidHost);
        this.raidHost = null;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public RaidBucket getRaidBucket() {
        return RaidBucketRegistry.getBucket(this.raidBucket);
    }

    public RaidBoss getRaidBoss() {
        return RaidRegistry.getRaidBoss(this.raidBoss);
    }

    public ResourceLocation getRaidBossLocation() {
        return this.raidBoss;
    }

    public ResourceLocation getRaidStructure() {
        return this.raidStructure;
    }

    public void addPlayer(Player player) {
        this.playerQueue.add(player.getUUID());
        this.setChanged();
    }

    public boolean isPlayerParticipating(Player player) {
        return this.playerQueue.contains(player.getUUID());
    }

    public boolean isInProgress() {
        return !this.playerQueue.isEmpty() && this.dimension != null && !this.dimension.players().isEmpty();
    }

    public boolean isActive(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)RaidCrystalBlock.ACTIVE) != false && blockState.getValue(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE && this.raidBoss != null;
    }

    public boolean canTick(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)RaidCrystalBlock.ACTIVE);
    }

    public boolean renderBeacon(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)RaidCrystalBlock.ACTIVE) != false && blockState.getValue(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE;
    }

    public void resetClears() {
        this.clears = 0;
    }

    public boolean isAtMaxClears() {
        return CobblemonRaidDens.CONFIG.max_clears != -1 && this.clears >= CobblemonRaidDens.CONFIG.max_clears;
    }

    public ServerLevel getDimension() {
        return this.dimension;
    }

    public void setDimension(ServerLevel level) {
        this.dimension = level;
    }

    public boolean hasDimension() {
        return this.dimension != null;
    }

    public boolean isFull() {
        return CobblemonRaidDens.CONFIG.max_players != -1 && this.playerQueue.size() >= CobblemonRaidDens.CONFIG.max_players;
    }

    public boolean isBusy() {
        return this.queueClose || this.queueFindDimension;
    }

    public void setQueueClose() {
        this.queueClose = true;
    }

    public void setRaidBucket(ResourceLocation bucket) {
        this.raidBucket = bucket;
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (compoundTag.contains("raid_host_uuid")) {
            this.raidHost = UUID.fromString(compoundTag.getString("raid_host_uuid"));
            this.queueFindDimension = true;
        }
        if (compoundTag.contains("raid_player_queue")) {
            compoundTag.getList("raid_player_queue", 8).forEach(tag -> this.playerQueue.add(UUID.fromString(tag.getAsString())));
        }
        this.clears = compoundTag.getInt("raid_cleared");
        this.lastReset = compoundTag.getLong("last_reset");
        this.inactiveTicks = compoundTag.getInt("raid_inactive_for");
        this.uuid = compoundTag.contains("uuid") ? UUID.fromString(compoundTag.getString("uuid")) : UUID.randomUUID();
        if (compoundTag.contains("raid_bucket")) {
            this.raidBucket = ResourceLocation.parse((String)compoundTag.getString("raid_bucket"));
        }
        if (compoundTag.contains("raid_boss")) {
            this.raidBoss = ResourceLocation.parse((String)compoundTag.getString("raid_boss"));
        }
        this.raidStructure = compoundTag.contains("raid_structure") ? ResourceLocation.parse((String)compoundTag.getString("raid_structure")) : RaidDenRegistry.DEFAULT;
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (this.raidHost != null) {
            compoundTag.putString("raid_host_uuid", this.raidHost.toString());
        } else if (this.dimension != null) {
            compoundTag.putString("raid_host_uuid", this.dimension.dimension().location().getPath());
        }
        ListTag playerQueueTag = new ListTag();
        this.playerQueue.forEach(uuid -> playerQueueTag.add((Object)StringTag.valueOf((String)uuid.toString())));
        compoundTag.put("raid_player_queue", (Tag)playerQueueTag);
        compoundTag.putInt("raid_cleared", this.clears);
        compoundTag.putLong("last_reset", this.lastReset);
        compoundTag.putInt("raid_inactive_for", this.inactiveTicks);
        if (this.uuid != null) {
            compoundTag.putString("uuid", this.uuid.toString());
        }
        if (this.raidBucket != null) {
            compoundTag.putString("raid_bucket", this.raidBucket.toString());
        }
        if (this.raidBoss != null) {
            compoundTag.putString("raid_boss", this.raidBoss.toString());
        }
        if (this.raidStructure != null) {
            compoundTag.putString("raid_structure", this.raidStructure.toString());
        }
    }

    public void setRaidBoss(ResourceLocation raidBoss, RandomSource random, long gameTime) {
        RaidHelper.resetClearedRaids(this.getUuid());
        this.resetClears();
        this.inactiveTicks = 0;
        this.lastReset = gameTime;
        this.raidBoss = raidBoss;
        this.raidStructure = raidBoss == null ? null : this.getRaidBoss().getRandomDen(random);
        this.setChanged();
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        if (this.raidBoss != null) {
            tag.putString("raid_boss", this.raidBoss.toString());
        }
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

