/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.entity;

import com.necro.raid.dens.common.dimensions.ModDimensions;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class RaidHomeBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private BlockPos homePos;
    private ResourceKey<Level> home;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RaidHomeBlockEntity(BlockEntityType<? extends RaidHomeBlockEntity> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public void setHome(BlockPos homePos, ResourceKey<Level> home) {
        this.homePos = homePos;
        this.home = home;
    }

    public void setHome(BlockPos homePos, ServerLevel level) {
        this.setHome(homePos, (ResourceKey<Level>)level.dimension());
    }

    public BlockPos getHomePos() {
        return this.homePos;
    }

    public ResourceKey<Level> getHome() {
        return this.home;
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (!compoundTag.contains("home_pos") || !compoundTag.contains("home_level")) {
            return;
        }
        int[] coords = compoundTag.getIntArray("home_pos");
        this.homePos = new BlockPos(coords[0], coords[1], coords[2]);
        this.home = ModDimensions.createLevelKey(ResourceLocation.parse((String)compoundTag.getString("home_level")));
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (this.homePos == null || this.home == null) {
            return;
        }
        compoundTag.putIntArray("home_pos", List.of(Integer.valueOf(this.homePos.getX()), Integer.valueOf(this.homePos.getY()), Integer.valueOf(this.homePos.getZ())));
        compoundTag.putString("home_level", this.home.location().toString());
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

