/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.PassActionResponse;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.net.messages.client.battle.BattleApplyPassResponsePacket;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.events.RaidEndEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.items.ModItems;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RewardHandler;
import com.necro.raid.dens.common.showdown.bagitems.CheerBagItem;
import com.necro.raid.dens.common.showdown.bagitems.PlayerJoinBagItem;
import com.necro.raid.dens.common.showdown.bagitems.StatChangeBagItem;
import com.necro.raid.dens.common.util.IHealthSetter;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class RaidInstance {
    private static final Map<String, BiConsumer<RaidInstance, PokemonBattle>> INSTRUCTION_MAP = new HashMap<String, BiConsumer<RaidInstance, PokemonBattle>>();
    private final PokemonEntity bossEntity;
    private final RaidBoss raidBoss;
    private final ServerBossEvent bossEvent;
    private final List<PokemonBattle> battles;
    private final Map<ServerPlayer, Float> damageCache;
    private final List<ServerPlayer> activePlayers;
    private final List<ServerPlayer> failedPlayers;
    private float currentHealth;
    private float maxHealth;
    private final float initMaxHealth;
    private final Map<Integer, String> scriptByTurn;
    private final NavigableMap<Double, String> scriptByHp;
    private final Map<ServerPlayer, Integer> cheersLeft;
    private final List<DelayedRunnable> runQueue;

    public RaidInstance(PokemonEntity entity) {
        this.bossEntity = entity;
        this.raidBoss = ((IRaidAccessor)entity).getRaidBoss();
        this.bossEvent = new ServerBossEvent((Component)((MutableComponent)entity.getName()).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.WHITE), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_10);
        this.battles = new ArrayList<PokemonBattle>();
        this.damageCache = new HashMap<ServerPlayer, Float>();
        this.activePlayers = new ArrayList<ServerPlayer>();
        this.failedPlayers = new ArrayList<ServerPlayer>();
        this.currentHealth = entity.getPokemon().getCurrentHealth();
        this.initMaxHealth = this.maxHealth = (float)entity.getPokemon().getMaxHealth();
        this.scriptByTurn = new HashMap<Integer, String>();
        this.scriptByHp = new TreeMap<Double, String>();
        this.raidBoss.getScript().forEach((key, func) -> {
            if (!INSTRUCTION_MAP.containsKey(func)) {
                return;
            }
            try {
                if (key.startsWith("turn:")) {
                    this.scriptByTurn.put(Integer.parseInt(key.split(":")[1]), (String)func);
                } else if (key.startsWith("hp:")) {
                    double threshold = Double.parseDouble(key.split(":")[1]);
                    if ((double)(this.currentHealth / this.maxHealth) < threshold) {
                        return;
                    }
                    this.scriptByHp.put(threshold, (String)func);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.cheersLeft = new HashMap<ServerPlayer, Integer>();
        this.runQueue = new ArrayList<DelayedRunnable>();
        this.runQueue.add(new DelayedRunnable(() -> {
            if (this.bossEntity.isDeadOrDying()) {
                return;
            }
            for (ServerPlayer player : this.activePlayers) {
                if (player.level() == this.bossEntity.level()) continue;
                this.removePlayer(player);
            }
        }, 20, true));
    }

    public void addPlayer(ServerPlayer player, PokemonBattle battle) {
        ((IRaidBattle)battle).setRaidBattle(this);
        this.battles.add(battle);
        this.bossEvent.addPlayer(player);
        this.damageCache.put(player, Float.valueOf(this.currentHealth));
        if (!this.activePlayers.isEmpty() && CobblemonRaidDens.CONFIG.multiplayer_health_multiplier > 1.0f) {
            this.applyHealthMulti(player);
        }
        this.cheersLeft.put(player, CobblemonRaidDens.CONFIG.max_cheers);
        this.activePlayers.add(player);
        RaidDenNetworkMessages.SYNC_HEALTH.accept(player, Float.valueOf(this.currentHealth / this.maxHealth));
    }

    private void applyHealthMulti(ServerPlayer newPlayer) {
        float bonusHealth = this.initMaxHealth * (CobblemonRaidDens.CONFIG.multiplayer_health_multiplier - 1.0f) * (float)this.activePlayers.size();
        float currentRatio = this.currentHealth / this.maxHealth;
        this.maxHealth = this.initMaxHealth + bonusHealth;
        this.currentHealth = this.maxHealth * currentRatio;
        ((IHealthSetter)this.bossEntity.getPokemon()).setMaxHealth((int)this.maxHealth, false);
        this.bossEntity.getPokemon().setCurrentHealth((int)this.currentHealth);
        this.battles.forEach(b -> {
            ServerPlayer player = (ServerPlayer)b.getPlayers().getFirst();
            ((IRaidBattle)b).addToQueue((raid, battle) -> raid.playerJoin((PokemonBattle)battle, player, (Player)newPlayer));
        });
    }

    public void addPlayer(PokemonBattle battle) {
        this.addPlayer((ServerPlayer)battle.getPlayers().getFirst(), battle);
    }

    public void removePlayer(ServerPlayer player, PokemonBattle battle) {
        this.battles.remove(battle);
        ((IRaidBattle)battle).setRaidBattle(null);
        this.bossEvent.removePlayer(player);
        this.damageCache.remove(player);
        this.failedPlayers.add(player);
    }

    public void removePlayer(PokemonBattle battle) {
        this.removePlayer((ServerPlayer)battle.getPlayers().getFirst(), battle);
    }

    public void removePlayer(ServerPlayer player) {
        this.bossEvent.removePlayer(player);
        this.damageCache.remove(player);
    }

    public void syncHealth(ServerPlayer player, PokemonBattle battle, float remainingHealth) {
        if (!this.activePlayers.contains(player) && ((IRaidBattle)battle).isRaidBattle()) {
            this.addPlayer(player, battle);
        }
        float damage = this.damageCache.get(player).floatValue() - remainingHealth;
        this.damageCache.put(player, Float.valueOf(remainingHealth));
        this.currentHealth = Math.clamp(this.currentHealth - damage, 0.0f, this.maxHealth);
        this.activePlayers.forEach(p -> RaidDenNetworkMessages.SYNC_HEALTH.accept((ServerPlayer)p, Float.valueOf(this.currentHealth / this.maxHealth)));
        if (this.currentHealth == 0.0f) {
            this.bossEvent.setProgress(this.currentHealth / this.maxHealth);
            this.queueStopRaid();
        } else {
            this.runQueue.add(new DelayedRunnable(() -> {
                this.bossEvent.setProgress(this.currentHealth / this.maxHealth);
                this.runScriptByHp((double)this.currentHealth / (double)this.maxHealth);
            }, 20));
        }
    }

    public float getRemainingHealth() {
        return this.currentHealth;
    }

    public boolean hasFailed(ServerPlayer player) {
        return this.failedPlayers.contains(player);
    }

    public void tick() {
        this.runQueue.removeIf(DelayedRunnable::tick);
    }

    public void queueStopRaid() {
        this.queueStopRaid(true);
    }

    public void queueStopRaid(boolean raidSuccess) {
        this.runQueue.add(new DelayedRunnable(() -> this.stopRaid(raidSuccess), 60));
    }

    public void stopRaid(boolean raidSuccess) {
        this.bossEvent.setVisible(false);
        this.bossEvent.removeAllPlayers();
        if (raidSuccess) {
            this.bossEntity.setHealth(0.0f);
        }
        RaidHelper.ACTIVE_RAIDS.remove(((IRaidAccessor)this.bossEntity).getRaidId());
        this.battles.forEach(PokemonBattle::stop);
        if (this.raidBoss == null) {
            return;
        }
        if (raidSuccess) {
            this.handleSuccess();
        } else {
            this.handleFailed();
        }
    }

    private void handleSuccess() {
        List<Object> failed;
        List<Object> success;
        int catches = this.raidBoss.getMaxCatches();
        if (catches < 0 || this.activePlayers.size() < catches) {
            success = this.activePlayers;
            failed = List.of();
        } else if (catches == 0) {
            success = List.of();
            failed = this.activePlayers;
        } else {
            Collections.shuffle(this.activePlayers);
            success = this.activePlayers.subList(0, catches);
            failed = this.activePlayers.subList(catches, this.activePlayers.size());
        }
        success.forEach(player -> {
            new RewardHandler(this.raidBoss, (ServerPlayer)player, true).sendRewardMessage();
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((ServerPlayer)player, this.raidBoss, true)});
        });
        failed.forEach(player -> {
            new RewardHandler(this.raidBoss, (ServerPlayer)player, false).sendRewardMessage();
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((ServerPlayer)player, this.raidBoss, true)});
        });
    }

    private void handleFailed() {
        this.activePlayers.forEach(player -> {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.raid_fail"));
            RaidEvents.RAID_END.emit((Object[])new RaidEndEvent[]{new RaidEndEvent((ServerPlayer)player, this.raidBoss, false)});
        });
    }

    public RaidBoss getRaidBoss() {
        return this.raidBoss;
    }

    public void runScriptByTurn(PokemonBattle battle, int turn) {
        String func = this.scriptByTurn.remove(turn);
        if (func == null) {
            return;
        }
        ((IRaidBattle)battle).addToQueue(INSTRUCTION_MAP.get(func));
    }

    public void runScriptByHp(double hpRatio) {
        this.scriptByHp.tailMap(hpRatio, true).values().forEach(func -> this.battles.forEach(battle -> ((IRaidBattle)battle).addToQueue(INSTRUCTION_MAP.get(func))));
        this.scriptByHp.keySet().removeIf(hp -> hp >= hpRatio);
    }

    public boolean runCheer(ServerPlayer player, PokemonBattle oBattle, BagItem bagItem, String data) {
        int cheersLeft = this.cheersLeft.getOrDefault(player, 0);
        if (cheersLeft <= 0) {
            return false;
        }
        this.cheersLeft.put(player, --cheersLeft);
        this.cheer(oBattle, bagItem, data, false);
        for (PokemonBattle b : this.battles) {
            if (b == oBattle) continue;
            ((IRaidBattle)b).addToQueue((raid, battle) -> raid.cheer((PokemonBattle)battle, bagItem, data, true));
        }
        return true;
    }

    public void playerJoin(PokemonBattle battle, ServerPlayer player, Player newPlayer) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String data = String.format("%s %s", (int)this.currentHealth, newPlayer.getName().getString());
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse((BagItem)new PlayerJoinBagItem(), bp, data));
        this.damageCache.put(player, Float.valueOf((float)Math.floor(this.currentHealth)));
    }

    public void cheer(PokemonBattle battle, BagItem bagItem, String data, boolean skipEnemyAction) {
        PokemonEntity pokemonEntity;
        CheerBagItem cheerBagItem;
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side1.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null || target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        if (bagItem instanceof CheerBagItem && (cheerBagItem = (CheerBagItem)bagItem).cheerType() == CheerBagItem.CheerType.HEAL && (pokemonEntity = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon().getEntity()) instanceof PokemonEntity) {
            PokemonEntity entity = pokemonEntity;
            entity.playSound(CobblemonSounds.MEDICINE_HERB_USE, 1.0f, 1.0f);
        }
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(bagItem, ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon(), data), skipEnemyAction);
    }

    private void changeBossStat(@NotNull PokemonBattle battle, Stat stat, int stages) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String key = bp.getUuid().toString();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse((BagItem)new StatChangeBagItem(stat, stages), bp, key));
    }

    private void changePlayerStat(@NotNull PokemonBattle battle, Stat stat, int stages) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side1.getActivePokemon();
        List origin = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        if (origin.isEmpty() || ((ActiveBattlePokemon)origin.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String key = ((ActiveBattlePokemon)origin.getFirst()).getBattlePokemon().getUuid().toString();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse((BagItem)new StatChangeBagItem(stat, stages), bp, key));
    }

    private void clearBossStats(@NotNull PokemonBattle battle) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String key = bp.getUuid().toString();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(ModItems.CLEAR_BOSS, bp, key));
    }

    private void clearPlayerStats(@NotNull PokemonBattle battle) {
        BattleActor side1 = battle.getSide1().getActors()[0];
        BattleActor side2 = battle.getSide2().getActors()[0];
        List target = side1.getActivePokemon();
        List origin = side2.getActivePokemon();
        if (side1.getRequest() == null || side2.getRequest() == null) {
            return;
        }
        if (target.isEmpty() || ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon() == null) {
            return;
        }
        if (origin.isEmpty() || ((ActiveBattlePokemon)origin.getFirst()).getBattlePokemon() == null) {
            return;
        }
        BattlePokemon bp = ((ActiveBattlePokemon)target.getFirst()).getBattlePokemon();
        String key = ((ActiveBattlePokemon)origin.getFirst()).getBattlePokemon().getUuid().toString();
        this.sendAction(side1, side2, (ShowdownActionResponse)new BagItemActionResponse(ModItems.CLEAR_PLAYER, bp, key));
    }

    private void sendAction(BattleActor side1, BattleActor side2, ShowdownActionResponse response) {
        this.sendAction(side1, side2, response, true);
    }

    private void sendAction(BattleActor side1, BattleActor side2, ShowdownActionResponse response, boolean skipEnemyAction) {
        side1.getResponses().add(response);
        side1.setMustChoose(false);
        if (skipEnemyAction) {
            side2.getResponses().addFirst(PassActionResponse.INSTANCE);
            side2.setMustChoose(false);
        }
        side1.getBattle().checkForInputDispatch();
        side1.sendUpdate((NetworkPacket)new BattleApplyPassResponsePacket());
    }

    static {
        INSTRUCTION_MAP.put("RESET_BOSS", RaidInstance::clearBossStats);
        INSTRUCTION_MAP.put("RESET_PLAYER", RaidInstance::clearPlayerStats);
        INSTRUCTION_MAP.put("BOSS_ATK_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.ATTACK, 1));
        INSTRUCTION_MAP.put("BOSS_ATK_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.ATTACK, 2));
        INSTRUCTION_MAP.put("BOSS_DEF_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.DEFENCE, 1));
        INSTRUCTION_MAP.put("BOSS_DEF_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.DEFENCE, 2));
        INSTRUCTION_MAP.put("BOSS_SPA_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPECIAL_ATTACK, 1));
        INSTRUCTION_MAP.put("BOSS_SPA_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPECIAL_ATTACK, 2));
        INSTRUCTION_MAP.put("BOSS_SPD_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPECIAL_DEFENCE, 1));
        INSTRUCTION_MAP.put("BOSS_SPD_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPECIAL_DEFENCE, 2));
        INSTRUCTION_MAP.put("BOSS_SPE_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPEED, 1));
        INSTRUCTION_MAP.put("BOSS_SPE_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.SPEED, 2));
        INSTRUCTION_MAP.put("BOSS_ACC_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.ACCURACY, 1));
        INSTRUCTION_MAP.put("BOSS_ACC_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.ACCURACY, 2));
        INSTRUCTION_MAP.put("BOSS_EVA_1", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.EVASION, 1));
        INSTRUCTION_MAP.put("BOSS_EVA_2", (r, b) -> r.changeBossStat((PokemonBattle)b, (Stat)Stats.EVASION, 2));
        INSTRUCTION_MAP.put("PLAYER_ATK_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.ATTACK, -1));
        INSTRUCTION_MAP.put("PLAYER_ATK_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.ATTACK, -2));
        INSTRUCTION_MAP.put("PLAYER_DEF_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.DEFENCE, -1));
        INSTRUCTION_MAP.put("PLAYER_DEF_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.DEFENCE, -2));
        INSTRUCTION_MAP.put("PLAYER_SPA_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPECIAL_ATTACK, -1));
        INSTRUCTION_MAP.put("PLAYER_SPA_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPECIAL_ATTACK, -2));
        INSTRUCTION_MAP.put("PLAYER_SPD_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPECIAL_DEFENCE, -1));
        INSTRUCTION_MAP.put("PLAYER_SPD_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPECIAL_DEFENCE, -2));
        INSTRUCTION_MAP.put("PLAYER_SPE_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPEED, -1));
        INSTRUCTION_MAP.put("PLAYER_SPE_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.SPEED, -2));
        INSTRUCTION_MAP.put("PLAYER_ACC_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.ACCURACY, -1));
        INSTRUCTION_MAP.put("PLAYER_ACC_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.ACCURACY, -2));
        INSTRUCTION_MAP.put("PLAYER_EVA_1", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.EVASION, -1));
        INSTRUCTION_MAP.put("PLAYER_EVA_2", (r, b) -> r.changePlayerStat((PokemonBattle)b, (Stat)Stats.EVASION, -2));
    }

    private static class DelayedRunnable {
        private final Runnable runnable;
        private final int delay;
        private int tick;
        private final boolean repeat;

        public DelayedRunnable(Runnable runnable, int delay, boolean repeat) {
            this.runnable = runnable;
            this.delay = delay;
            this.tick = 0;
            this.repeat = repeat;
        }

        public DelayedRunnable(Runnable runnable, int delay) {
            this(runnable, delay, false);
        }

        public boolean tick() {
            if (++this.tick < this.delay) {
                return false;
            }
            this.runnable.run();
            if (this.repeat) {
                this.tick = 0;
            }
            return !this.repeat;
        }
    }
}

