/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.worldgen;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidCycleMode;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import com.necro.raid.dens.common.util.RaidRegistry;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class RaidDenFeature
extends Feature<BlockStateConfiguration> {
    public RaidDenFeature() {
        super(BlockStateConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        if (!CobblemonRaidDens.CONFIG.enable_spawning) {
            return false;
        }
        if (Arrays.stream(RaidTier.values()).noneMatch(RaidTier::isPresent)) {
            return false;
        }
        if (Arrays.stream(RaidType.values()).noneMatch(RaidType::isPresent)) {
            return false;
        }
        WorldGenLevel level = context.level();
        BlockPos blockPos = context.origin();
        BlockState blockState = ((BlockStateConfiguration)context.config()).state;
        if (level.isClientSide()) {
            return false;
        }
        if (!RaidUtils.hasSkyAccess((LevelReader)level, blockPos)) {
            return false;
        }
        if (!level.getBlockState(blockPos.below()).isSolidRender((BlockGetter)level, blockPos.below())) {
            return false;
        }
        RaidCycleMode cycleMode = RaidCycleMode.fromString(CobblemonRaidDens.CONFIG.cycle_mode);
        ResourceLocation bucket = null;
        ResourceLocation location = null;
        RaidBoss raidBoss = null;
        if (cycleMode == RaidCycleMode.BUCKET && level.getServer() != null && (bucket = RaidBucketRegistry.getRandomBucket(level.getRandom(), (Holder<Biome>)level.getBiome(blockPos))) != null) {
            location = RaidBucketRegistry.getBucket(bucket).getRandomRaidBoss(level.getRandom(), (Level)level.getLevel());
            raidBoss = RaidRegistry.getRaidBoss(location);
        }
        if (raidBoss == null) {
            location = RaidRegistry.getRandomRaidBoss(context.random(), (Level)level.getLevel());
            raidBoss = RaidRegistry.getRaidBoss(location);
        }
        if (raidBoss == null) {
            return false;
        }
        level.setBlock(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)RaidCrystalBlock.CAN_RESET, (Comparable)Boolean.valueOf(CobblemonRaidDens.CONFIG.reset_time > 0))).setValue(RaidCrystalBlock.CYCLE_MODE, (Comparable)((Object)cycleMode))).setValue(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).setValue(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier())), 2);
        RaidCrystalBlockEntity blockEntity = (RaidCrystalBlockEntity)level.getBlockEntity(blockPos);
        if (blockEntity != null) {
            blockEntity.setRaidBoss(location, level.getRandom(), level.getLevel().getGameTime());
            blockEntity.setRaidBucket(bucket);
        }
        return true;
    }
}

