/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.neoforge.events.reloader;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.util.RaidBucket;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.NotNull;

public class RaidBucketReloadListener
implements ResourceManagerReloadListener {
    public void onResourceManagerReload(@NotNull ResourceManager manager) {
        RaidBucketRegistry.clear();
        manager.listResources("raid/bucket", path -> path.toString().endsWith(".json")).forEach((id, resource) -> {
            try (InputStream input = resource.open();){
                JsonObject jsonObject = JsonParser.parseReader((Reader)new InputStreamReader(input, StandardCharsets.UTF_8)).getAsJsonObject();
                ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().replace("raid/bucket/", "").replace(".json", ""));
                Optional<RaidBucket> bucketOpt = RaidBucket.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).result().map(Pair::getFirst);
                bucketOpt.ifPresent(bucket -> {
                    bucket.setId(key);
                    RaidBucketRegistry.register(bucket);
                });
            }
            catch (Exception e) {
                CobblemonRaidDens.LOGGER.error("Failed to load raid bucket {}", id, (Object)e);
            }
        });
    }
}

