/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.neoforge.network;

import com.necro.raid.dens.common.network.packets.JoinRaidPacket;
import com.necro.raid.dens.common.network.packets.LeaveRaidPacket;
import com.necro.raid.dens.common.network.packets.RaidAspectPacket;
import com.necro.raid.dens.common.network.packets.RaidChallengePacket;
import com.necro.raid.dens.common.network.packets.RequestPacket;
import com.necro.raid.dens.common.network.packets.RequestResponsePacket;
import com.necro.raid.dens.common.network.packets.ResizePacket;
import com.necro.raid.dens.common.network.packets.RewardPacket;
import com.necro.raid.dens.common.network.packets.RewardResponsePacket;
import com.necro.raid.dens.common.network.packets.SyncHealthPacket;
import com.necro.raid.dens.common.network.packets.SyncRaidDimensionsPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="cobblemonraiddens")
public class NetworkMessages {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar payloadRegistrar = event.registrar("cobblemonraiddens").versioned("1.0.0").optional();
        payloadRegistrar.playToClient(SyncRaidDimensionsPacket.PACKET_TYPE, SyncRaidDimensionsPacket.CODEC, NetworkMessages::handleSyncDim);
        payloadRegistrar.playToClient(SyncHealthPacket.PACKET_TYPE, SyncHealthPacket.CODEC, NetworkMessages::handleSyncHealth);
        payloadRegistrar.playToClient(JoinRaidPacket.PACKET_TYPE, JoinRaidPacket.CODEC, NetworkMessages::handleJoinRaid);
        payloadRegistrar.playToClient(RequestPacket.PACKET_TYPE, RequestPacket.CODEC, NetworkMessages::handleRequest);
        payloadRegistrar.playToClient(RewardPacket.PACKET_TYPE, RewardPacket.CODEC, NetworkMessages::handleReward);
        payloadRegistrar.playToClient(RewardPacket.PACKET_TYPE, RewardPacket.CODEC, NetworkMessages::handleReward);
        payloadRegistrar.playToClient(ResizePacket.PACKET_TYPE, ResizePacket.CODEC, NetworkMessages::handleResize);
        payloadRegistrar.playToClient(RaidAspectPacket.PACKET_TYPE, RaidAspectPacket.CODEC, NetworkMessages::handleRaidAspect);
        payloadRegistrar.playToServer(RaidChallengePacket.PACKET_TYPE, RaidChallengePacket.CODEC, NetworkMessages::handleRaidChallenge);
        payloadRegistrar.playToServer(LeaveRaidPacket.PACKET_TYPE, LeaveRaidPacket.CODEC, NetworkMessages::handleLeaveRaid);
        payloadRegistrar.playToServer(RequestResponsePacket.PACKET_TYPE, RequestResponsePacket.CODEC, NetworkMessages::handleRequestResponse);
        payloadRegistrar.playToServer(RewardResponsePacket.PACKET_TYPE, RewardResponsePacket.CODEC, NetworkMessages::handleRewardResponse);
    }

    public static void sendPacketToServer(CustomPacketPayload packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPacketToAll(CustomPacketPayload packet) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPacketToLevel(ServerLevel level, CustomPacketPayload packet) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendPacketToPlayer(ServerPlayer player, CustomPacketPayload packet) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void handleSyncDim(SyncRaidDimensionsPacket packet, IPayloadContext context) {
        context.enqueueWork(packet::handleClient);
    }

    public static void handleSyncHealth(SyncHealthPacket packet, IPayloadContext context) {
        context.enqueueWork(packet::handleClient);
    }

    public static void handleRaidChallenge(RaidChallengePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> packet.handleServer((ServerPlayer)context.player()));
    }

    public static void handleJoinRaid(JoinRaidPacket packet, IPayloadContext context) {
        context.enqueueWork(packet::handleClient);
    }

    public static void handleLeaveRaid(LeaveRaidPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> packet.handleServer((ServerPlayer)context.player()));
    }

    public static void handleRequest(RequestPacket packet, IPayloadContext context) {
        context.enqueueWork(packet::handleClient);
    }

    public static void handleRequestResponse(RequestResponsePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> packet.handleServer((ServerPlayer)context.player()));
    }

    public static void handleReward(RewardPacket packet, IPayloadContext context) {
        context.enqueueWork(packet::handleClient);
    }

    public static void handleRewardResponse(RewardResponsePacket packet, IPayloadContext context) {
        context.enqueueWork(() -> packet.handleServer((ServerPlayer)context.player()));
    }

    public static void handleResize(ResizePacket packet, IPayloadContext context) {
        context.enqueueWork(packet::handleClient);
    }

    public static void handleRaidAspect(RaidAspectPacket packet, IPayloadContext context) {
        context.enqueueWork(packet::handleClient);
    }
}

