/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.block;

import com.cobblemon.mod.common.pokemon.activestate.ActivePokemonState;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.blocks.entity.RaidHomeBlockEntity;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public abstract class RaidHomeBlock
extends BaseEntityBlock {
    public RaidHomeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos blockPos, Player player, BlockHitResult blockHitResult) {
        if (!level.isClientSide()) {
            RaidHomeBlockEntity blockEntity = (RaidHomeBlockEntity)level.getBlockEntity(blockPos);
            if (blockEntity == null) {
                return InteractionResult.FAIL;
            }
            boolean success = RaidHomeBlock.safeExit(blockEntity, blockPos, (ServerPlayer)player, level);
            if (success) {
                RaidDenNetworkMessages.JOIN_RAID.accept((ServerPlayer)player, false);
            }
            return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean safeExit(RaidHomeBlockEntity blockEntity, BlockPos blockPos, ServerPlayer player, Level level) {
        BlockEntity blockEntity2;
        BlockPos homePos = blockEntity.getHomePos();
        if (homePos == null || level.getServer() == null) {
            return false;
        }
        ServerLevel home = level.getServer().getLevel(blockEntity.getHome());
        if (home == null) {
            return false;
        }
        if (level.getEntitiesOfClass(LivingEntity.class, new AABB(blockPos).inflate(32.0)).stream().anyMatch(LivingEntity::isDeadOrDying)) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.cannot_leave_yet").withStyle(ChatFormatting.RED));
            return false;
        }
        PlayerExtensionsKt.party((ServerPlayer)player).forEach(pokemon -> {
            if (pokemon.getState() instanceof ActivePokemonState) {
                pokemon.recall();
            }
        });
        RaidUtils.teleportPlayerSafe((Player)player, home, homePos, player.getYHeadRot(), player.getXRot());
        if (level.getEntitiesOfClass(LivingEntity.class, new AABB(blockPos).inflate(32.0)).isEmpty()) {
            BlockEntity blockEntity3 = home.getBlockEntity(homePos);
            if (blockEntity3 instanceof RaidCrystalBlockEntity) {
                RaidCrystalBlockEntity raidCrystalBlockEntity = (RaidCrystalBlockEntity)blockEntity3;
                raidCrystalBlockEntity.clearRaid();
            }
        } else if (level.getEntitiesOfClass(Player.class, new AABB(blockPos).inflate(32.0)).isEmpty() && (blockEntity2 = home.getBlockEntity(homePos)) instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystalBlockEntity = (RaidCrystalBlockEntity)blockEntity2;
            raidCrystalBlockEntity.setQueueClose();
        }
        return true;
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return null;
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

