/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.statistics;

import com.cobblemon.mod.common.api.Priority;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.raids.RaidTier;
import kotlin.Unit;
import net.minecraft.resources.ResourceLocation;

public class RaidStatistics {
    public static final ResourceLocation RAIDS_HOSTED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raids_hosted");
    public static final ResourceLocation RAIDS_JOINED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raids_joined");
    public static final ResourceLocation RAIDS_COMPLETED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raids_completed");
    public static final ResourceLocation TIER_ONE_COMPLETED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"tier_one_completed");
    public static final ResourceLocation TIER_TWO_COMPLETED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"tier_two_completed");
    public static final ResourceLocation TIER_THREE_COMPLETED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"tier_three_completed");
    public static final ResourceLocation TIER_FOUR_COMPLETED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"tier_four_completed");
    public static final ResourceLocation TIER_FIVE_COMPLETED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"tier_five_completed");
    public static final ResourceLocation TIER_SIX_COMPLETED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"tier_six_completed");
    public static final ResourceLocation TIER_SEVEN_COMPLETED = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"tier_seven_completed");

    public static void init() {
        RaidEvents.RAID_JOIN.subscribe(Priority.LOWEST, event -> {
            if (event.isHost()) {
                event.getPlayer().awardStat(RAIDS_HOSTED);
            }
            event.getPlayer().awardStat(RAIDS_JOINED);
            return Unit.INSTANCE;
        });
        RaidEvents.RAID_END.subscribe(Priority.LOWEST, event -> {
            if (!event.isWin()) {
                return Unit.INSTANCE;
            }
            event.getPlayer().awardStat(RAIDS_COMPLETED);
            ResourceLocation tier = switch (event.getRaidBoss().getTier()) {
                default -> throw new MatchException(null, null);
                case RaidTier.TIER_ONE -> TIER_ONE_COMPLETED;
                case RaidTier.TIER_TWO -> TIER_TWO_COMPLETED;
                case RaidTier.TIER_THREE -> TIER_THREE_COMPLETED;
                case RaidTier.TIER_FOUR -> TIER_FOUR_COMPLETED;
                case RaidTier.TIER_FIVE -> TIER_FIVE_COMPLETED;
                case RaidTier.TIER_SIX -> TIER_SIX_COMPLETED;
                case RaidTier.TIER_SEVEN -> TIER_SEVEN_COMPLETED;
            };
            event.getPlayer().awardStat(tier);
            return Unit.INSTANCE;
        });
    }
}

