/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins;

import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.exception.IllegalActionChoiceException;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MoveActionResponse.class})
public abstract class MoveActionResponseMixin {
    @Shadow(remap=false)
    private String moveName;

    @Inject(method={"isValid(Lcom/cobblemon/mod/common/battles/ActiveBattlePokemon;Lcom/cobblemon/mod/common/battles/ShowdownMoveset;Z)Z"}, at={@At(value="HEAD")}, remap=false)
    private void isValidInject(ActiveBattlePokemon activeBattlePokemon, ShowdownMoveset showdownMoveSet, boolean forceSwitch, CallbackInfoReturnable<Boolean> cir) {
        List targetPokemon = activeBattlePokemon.getActor().getBattle().getSide2().getActivePokemon();
        if (targetPokemon.isEmpty()) {
            return;
        }
        if (targetPokemon.contains(activeBattlePokemon)) {
            return;
        }
        BattlePokemon battlePokemon = ((ActiveBattlePokemon)targetPokemon.getFirst()).getBattlePokemon();
        if (battlePokemon == null) {
            return;
        }
        PokemonEntity pokemonEntity = battlePokemon.getEntity();
        if (pokemonEntity == null) {
            return;
        }
        if (!((IRaidAccessor)pokemonEntity).isRaidBoss()) {
            return;
        }
        if (!RaidUtils.isMoveBlacklisted(this.moveName)) {
            return;
        }
        BattleActor battleActor = activeBattlePokemon.getActor();
        List originalActions = battleActor.getExpectingPassActions().stream().toList();
        battleActor.getExpectingPassActions().clear();
        battleActor.getExpectingPassActions().addAll(originalActions);
        throw new IllegalActionChoiceException(battleActor, Component.translatable((String)"message.cobblemonraiddens.raid.forbidden_move", (Object[])new Object[]{Component.translatable((String)("cobblemon.move." + this.moveName))}).getString());
    }
}

