/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.neoforge.events.reloader;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import java.io.InputStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import org.jetbrains.annotations.NotNull;

public class RaidTemplateReloadListener
implements ResourceManagerReloadListener {
    public void onResourceManagerReload(@NotNull ResourceManager manager) {
        RaidDenRegistry.clear();
        manager.listResources("structure/raid_den", path -> path.toString().endsWith(".nbt")).forEach((id, resource) -> {
            try (InputStream input = resource.open();){
                CompoundTag nbt = NbtIo.readCompressed((InputStream)input, (NbtAccounter)NbtAccounter.unlimitedHeap());
                if (!nbt.contains("raid_pois")) {
                    return;
                }
                ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().replace("structure/", "").replace(".nbt", ""));
                RaidDenRegistry.register(key, nbt.getCompound("raid_pois"));
            }
            catch (Exception e) {
                CobblemonRaidDens.LOGGER.error("Failed to load raid den template {}", id, (Object)e);
            }
        });
    }
}

