/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.client.gui.screens;

import com.necro.raid.dens.common.CobblemonRaidDensClient;
import com.necro.raid.dens.common.client.gui.RaidScreenComponents;
import com.necro.raid.dens.common.client.gui.buttons.AbstractRaidButton;
import com.necro.raid.dens.common.client.gui.screens.AbstractOverlay;
import com.necro.raid.dens.common.client.keybind.RaidDenKeybinds;
import com.necro.raid.dens.common.mixins.client.KeyMappingAccessor;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class RaidRewardOverlay
extends AbstractOverlay {
    private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"textures/gui/popup/overlay.png");
    private static final int WIDTH = 100;
    private static final int HEIGHT = 70;
    private final boolean isCatchable;
    private final String pokemon;

    public RaidRewardOverlay(boolean isCatchable, String pokemon) {
        this.isCatchable = isCatchable;
        this.pokemon = pokemon;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int maxX, int maxY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        int x = (int)((double)((maxX - 100) * CobblemonRaidDensClient.CLIENT_CONFIG.raid_popup_x) / 100.0);
        int y = (int)((double)((maxY - 70) * CobblemonRaidDensClient.CLIENT_CONFIG.raid_popup_y) / 100.0);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 4000.0f);
        guiGraphics.blit(OVERLAY, 0, 0, 0.0f, 0.0f, 100, 70, 100, 70);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.85f, 0.85f, 1.0f);
        guiGraphics.drawCenteredString(font, (Component)Component.translatable((String)"screen.cobblemonraiddens.reward.title").withStyle(ChatFormatting.GREEN), 58, 12, 0xFFFFFF);
        guiGraphics.pose().popPose();
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        MutableComponent component = this.isCatchable ? Component.translatable((String)"screen.cobblemonraiddens.reward.description.1", (Object[])new Object[]{Component.translatable((String)this.pokemon)}) : Component.translatable((String)"screen.cobblemonraiddens.reward.description.2", (Object[])new Object[]{Component.translatable((String)this.pokemon)});
        List wrapped = font.split((FormattedText)component, 184);
        int textY = wrapped.size() > 1 ? 44 : 52;
        for (FormattedCharSequence text : wrapped) {
            guiGraphics.drawCenteredString(font, text, 100, textY, 0xFFFFFF);
            Objects.requireNonNull(font);
            textY += 9 + 1;
        }
        guiGraphics.pose().popPose();
        if (!RaidDenKeybinds.MOUSE_KEYDOWN.isUnbound()) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
            Component key = RaidRewardOverlay.getShorthand(((KeyMappingAccessor)RaidDenKeybinds.MOUSE_KEYDOWN).getKey());
            guiGraphics.drawString(font, (Component)Component.translatable((String)"screen.cobblemonraiddens.footer", (Object[])new Object[]{key}), 10, 119, 0x9B9B9B, false);
            guiGraphics.pose().popPose();
        }
        guiGraphics.pose().popPose();
        if (this.isCatchable) {
            RaidScreenComponents.ACCEPT_REWARD_BUTTON.setPos(x + 4, y + 40);
            RaidScreenComponents.ACCEPT_REWARD_BUTTON.renderStatic(guiGraphics);
            RaidScreenComponents.DENY_REWARD_BUTTON.setPos(x + 51, y + 40);
            RaidScreenComponents.DENY_REWARD_BUTTON.renderStatic(guiGraphics);
        } else {
            RaidScreenComponents.DENY_WIDE_REWARD_BUTTON.setPos(x + 4, y + 40);
            RaidScreenComponents.DENY_WIDE_REWARD_BUTTON.renderStatic(guiGraphics);
        }
    }

    @Override
    public List<AbstractRaidButton> getButtons() {
        return this.isCatchable ? List.of(RaidScreenComponents.DENY_REWARD_BUTTON, RaidScreenComponents.ACCEPT_REWARD_BUTTON) : List.of(RaidScreenComponents.DENY_WIDE_REWARD_BUTTON);
    }
}

