/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.ModBlocks;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.events.RaidDenSpawnEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidCycleMode;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidBucket;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import com.necro.raid.dens.common.util.RaidRegistry;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class RaidDenCommands {
    public static final SuggestionProvider<CommandSourceStack> RAID_BOSSES = (context, builder) -> {
        String remaining = builder.getRemaining().toLowerCase();
        for (ResourceLocation id : RaidRegistry.getAll()) {
            if (!id.toString().toLowerCase().startsWith(remaining)) continue;
            builder.suggest(id.toString());
        }
        return builder.buildFuture();
    };
    public static final SuggestionProvider<CommandSourceStack> RAID_BUCKETS = (context, builder) -> {
        String remaining = builder.getRemaining().toLowerCase();
        Registry registry = ((CommandSourceStack)context.getSource()).getServer().registryAccess().registryOrThrow(RaidBucketRegistry.BUCKET_KEY);
        for (ResourceLocation id : registry.keySet()) {
            if (!id.toString().toLowerCase().startsWith(remaining)) continue;
            builder.suggest(id.toString());
        }
        return builder.buildFuture();
    };
    public static final SuggestionProvider<CommandSourceStack> RAID_TIERS = (context, builder) -> {
        String remaining = builder.getRemaining().toLowerCase();
        for (RaidTier tier : RaidTier.values()) {
            if (!tier.toString().toLowerCase().startsWith(remaining)) continue;
            builder.suggest(tier.name());
        }
        return builder.buildFuture();
    };
    public static final SuggestionProvider<CommandSourceStack> CYCLE_MODE = (context, builder) -> {
        String remaining = builder.getRemaining().toLowerCase();
        for (RaidCycleMode cycleMode : RaidCycleMode.values()) {
            if (!cycleMode.toString().toLowerCase().startsWith(remaining)) continue;
            builder.suggest(cycleMode.name());
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"crd").then(((LiteralArgumentBuilder)Commands.literal((String)"dens").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"position", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), (ResourceLocation)null, null, true))).then(Commands.literal((String)"tier").then(((RequiredArgumentBuilder)Commands.argument((String)"tier", (ArgumentType)StringArgumentType.word()).suggests(RAID_TIERS).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), null, true))).then(((RequiredArgumentBuilder)Commands.argument((String)"cycle_mode", (ArgumentType)StringArgumentType.word()).suggests(CYCLE_MODE).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), true))).then(Commands.argument((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset")))))))).then(Commands.literal((String)"boss").then(((RequiredArgumentBuilder)Commands.argument((String)"boss", (ArgumentType)ResourceLocationArgument.id()).suggests(RAID_BOSSES).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), null, true))).then(((RequiredArgumentBuilder)Commands.argument((String)"cycle_mode", (ArgumentType)StringArgumentType.word()).suggests(CYCLE_MODE).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), true))).then(Commands.argument((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset")))))))).then(Commands.literal((String)"bucket").then(((RequiredArgumentBuilder)Commands.argument((String)"bucket", (ArgumentType)ResourceLocationArgument.id()).suggests(RAID_BUCKETS).executes(context -> RaidDenCommands.createRaidDenWithBucket((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), ResourceLocationArgument.getId((CommandContext)context, (String)"bucket"), true))).then(Commands.argument((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDenWithBucket((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), ((CommandSourceStack)context.getSource()).getLevel(), ResourceLocationArgument.getId((CommandContext)context, (String)"bucket"), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset"))))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)DimensionArgument.dimension()).requires(context -> !context.isPlayer())).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), (ResourceLocation)null, null, true))).then(Commands.literal((String)"tier").then(((RequiredArgumentBuilder)Commands.argument((String)"tier", (ArgumentType)StringArgumentType.word()).suggests(RAID_TIERS).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), null, true))).then(((RequiredArgumentBuilder)Commands.argument((String)"cycle_mode", (ArgumentType)StringArgumentType.word()).suggests(CYCLE_MODE).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), true))).then(Commands.argument((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset")))))))).then(Commands.literal((String)"boss").then(((RequiredArgumentBuilder)Commands.argument((String)"boss", (ArgumentType)ResourceLocationArgument.id()).suggests(RAID_BOSSES).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), null, true))).then(((RequiredArgumentBuilder)Commands.argument((String)"cycle_mode", (ArgumentType)StringArgumentType.word()).suggests(CYCLE_MODE).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), true))).then(Commands.argument((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"boss"), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset")))))))).then(Commands.literal((String)"bucket").then(((RequiredArgumentBuilder)Commands.argument((String)"bucket", (ArgumentType)ResourceLocationArgument.id()).suggests(RAID_BUCKETS).executes(context -> RaidDenCommands.createRaidDenWithBucket((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"bucket"), true))).then(Commands.argument((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDenWithBucket((CommandContext<CommandSourceStack>)context, BlockPosArgument.getBlockPos((CommandContext)context, (String)"position"), DimensionArgument.getDimension((CommandContext)context, (String)"dimension"), ResourceLocationArgument.getId((CommandContext)context, (String)"bucket"), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset"))))))))));
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        RaidDenCommands.register(dispatcher);
    }

    private static void setCrystal(Level level, BlockPos blockPos, BlockState blockState, boolean canReset, RaidCycleMode cycleMode, ResourceLocation location, @Nullable ResourceLocation bucket) {
        RaidBoss raidBoss = RaidRegistry.getRaidBoss(location);
        level.setBlock(blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)RaidCrystalBlock.CAN_RESET, (Comparable)Boolean.valueOf(canReset))).setValue(RaidCrystalBlock.CYCLE_MODE, (Comparable)((Object)cycleMode))).setValue(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).setValue(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier())), 2);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
            raidCrystal.setRaidBoss(location, level.getRandom(), level.getGameTime());
            if (bucket != null) {
                raidCrystal.setRaidBucket(bucket);
            }
        }
        RaidEvents.RAID_DEN_SPAWN.emit((Object[])new RaidDenSpawnEvent[]{new RaidDenSpawnEvent((ServerLevel)level, blockPos, raidBoss)});
    }

    private static int createRaidDenFromExisting(Level level, RaidCrystalBlockEntity blockEntity, BlockPos blockPos, ResourceLocation location, RaidCycleMode cycleMode, boolean canReset) {
        RaidBucket rBucket;
        BlockState blockState = blockEntity.getBlockState();
        if (cycleMode == null) {
            cycleMode = (RaidCycleMode)((Object)blockState.getValue(RaidCrystalBlock.CYCLE_MODE));
        }
        ResourceLocation bucket = null;
        if (cycleMode == RaidCycleMode.BUCKET && location == null && (rBucket = blockEntity.getRaidBucket()) != null) {
            bucket = rBucket.getId();
            location = rBucket.getRandomRaidBoss(level.getRandom(), level);
        }
        if (location == null) {
            RaidTier tier = cycleMode.canCycleTier() ? RaidTier.getWeightedRandom(level.getRandom(), level) : (RaidTier)((Object)blockState.getValue(RaidCrystalBlock.RAID_TIER));
            RaidType type = cycleMode.canCycleType() ? null : (RaidType)((Object)blockState.getValue(RaidCrystalBlock.RAID_TYPE));
            location = RaidRegistry.getRandomRaidBoss(level.getRandom(), level, tier, type, null);
        }
        RaidDenCommands.setCrystal(level, blockPos, blockState, canReset, cycleMode, location, bucket);
        return 1;
    }

    private static int createRaidDenNew(Level level, BlockPos blockPos, ResourceLocation location, RaidCycleMode cycleMode, boolean canReset) {
        RaidBucket rBucket;
        if (cycleMode == null) {
            cycleMode = RaidCycleMode.fromString(CobblemonRaidDens.CONFIG.cycle_mode);
        }
        ResourceLocation bucket = null;
        if (cycleMode == RaidCycleMode.BUCKET && location == null && (rBucket = RaidBucketRegistry.getBucket(bucket = RaidBucketRegistry.getRandomBucket(level.getRandom(), (Holder<Biome>)level.getBiome(blockPos)))) != null) {
            location = rBucket.getRandomRaidBoss(level.getRandom(), level);
        }
        if (location == null) {
            location = RaidRegistry.getRandomRaidBoss(level.getRandom(), level);
        }
        RaidDenCommands.setCrystal(level, blockPos, ModBlocks.INSTANCE.getRaidCrystalBlock().defaultBlockState(), canReset, cycleMode, location, bucket);
        return 1;
    }

    private static int createRaidDen(CommandContext<CommandSourceStack> context, BlockPos blockPos, ServerLevel level, ResourceLocation raidBoss, RaidCycleMode cycleMode, boolean canReset) {
        if (level.getBiome(blockPos).is(ModDimensions.RAIDDIM_BIOME)) {
            return 0;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
            return RaidDenCommands.createRaidDenFromExisting((Level)level, raidCrystal, blockPos, raidBoss, cycleMode, canReset);
        }
        return RaidDenCommands.createRaidDenNew((Level)level, blockPos, raidBoss, cycleMode, canReset);
    }

    private static int createRaidDen(CommandContext<CommandSourceStack> context, BlockPos blockPos, ServerLevel level, RaidTier raidTier, RaidCycleMode cycleMode, boolean canReset) {
        if (!raidTier.isPresent()) {
            CobblemonRaidDens.LOGGER.info("No raid bosses for that tier could be found. Rolling random tier.");
        }
        BlockState blockState = level.getBlockState(blockPos);
        if (cycleMode == null) {
            cycleMode = blockState.hasProperty(RaidCrystalBlock.CYCLE_MODE) ? (RaidCycleMode)((Object)level.getBlockState(blockPos).getValue(RaidCrystalBlock.CYCLE_MODE)) : RaidCycleMode.fromString(CobblemonRaidDens.CONFIG.cycle_mode);
        }
        RandomSource random = ((CommandSourceStack)context.getSource()).getLevel().getRandom();
        RaidType type = !blockState.hasProperty(RaidCrystalBlock.RAID_TYPE) || cycleMode.canCycleType() ? null : (RaidType)((Object)level.getBlockState(blockPos).getValue(RaidCrystalBlock.RAID_TYPE));
        return RaidDenCommands.createRaidDen(context, blockPos, level, RaidRegistry.getRandomRaidBoss(random, (Level)level, raidTier, type, null), cycleMode, canReset);
    }

    private static int createRaidDenWithBucketFromExisting(Level level, BlockState blockState, BlockPos blockPos, ResourceLocation bucket, boolean canReset) {
        ResourceLocation location = RaidBucketRegistry.getBucket(bucket).getRandomRaidBoss(level.getRandom(), level);
        if (location == null) {
            RaidTier tier = RaidTier.getWeightedRandom(level.getRandom(), level);
            location = RaidRegistry.getRandomRaidBoss(level.getRandom(), level, tier, null, null);
        }
        RaidDenCommands.setCrystal(level, blockPos, blockState, canReset, RaidCycleMode.BUCKET, location, bucket);
        return 1;
    }

    private static int createRaidDenWithBucketNew(Level level, BlockPos blockPos, ResourceLocation bucket, boolean canReset) {
        ResourceLocation location = RaidBucketRegistry.getBucket(bucket).getRandomRaidBoss(level.getRandom(), level);
        if (location == null) {
            location = RaidRegistry.getRandomRaidBoss(level.getRandom(), level);
        }
        RaidDenCommands.setCrystal(level, blockPos, ModBlocks.INSTANCE.getRaidCrystalBlock().defaultBlockState(), canReset, RaidCycleMode.BUCKET, location, bucket);
        return 1;
    }

    private static int createRaidDenWithBucket(CommandContext<CommandSourceStack> context, BlockPos blockPos, ServerLevel level, ResourceLocation bucket, boolean canReset) {
        if (level.getBiome(blockPos).is(ModDimensions.RAIDDIM_BIOME)) {
            return 0;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
            return RaidDenCommands.createRaidDenWithBucketFromExisting((Level)level, raidCrystal.getBlockState(), blockPos, bucket, canReset);
        }
        return RaidDenCommands.createRaidDenWithBucketNew((Level)level, blockPos, bucket, canReset);
    }
}

