/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.dimensions;

import com.google.common.collect.ImmutableList;
import com.necro.raid.dens.common.blocks.ModBlocks;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.blocks.entity.RaidHomeBlockEntity;
import com.necro.raid.dens.common.dimensions.RaidDenChunkGenerator;
import com.necro.raid.dens.common.mixins.MappedRegistryAccessor;
import com.necro.raid.dens.common.mixins.MinecraftServerAccessor;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.Vec3;

public class ModDimensions {
    public static final ResourceKey<DimensionType> RAIDDIM_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raiddim_type"));
    public static final ResourceKey<Biome> RAIDDIM_BIOME = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_den"));

    public static void bootstrapType(BootstrapContext<DimensionType> context) {
        context.register(RAIDDIM_TYPE, (Object)new DimensionType(OptionalLong.of(6000L), false, false, false, false, 1.0, true, false, -64, 128, 128, BlockTags.AIR, BuiltinDimensionTypes.END_EFFECTS, 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.of((int)0, (int)0), 0)));
    }

    public static void bootstrapBiome(BootstrapContext<Biome> context) {
        BiomeSpecialEffects.Builder builder = new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011).fogColor(12638463).skyColor(0).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS);
        context.register(RAIDDIM_BIOME, (Object)new Biome.BiomeBuilder().hasPrecipitation(false).downfall(0.4f).temperature(0.7f).generationSettings(BiomeGenerationSettings.EMPTY).mobSpawnSettings(MobSpawnSettings.EMPTY).specialEffects(builder.build()).build());
    }

    public static LevelStem raidDimBuilder(MinecraftServer server, ResourceKey<LevelStem> dimensionKey) {
        RegistryAccess.Frozen registries = server.registryAccess();
        return new LevelStem((Holder)registries.registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(RAIDDIM_TYPE), (ChunkGenerator)new RaidDenChunkGenerator((Holder.Reference<Biome>)registries.registryOrThrow(Registries.BIOME).getHolderOrThrow(RAIDDIM_BIOME)));
    }

    public static ResourceKey<Level> createLevelKey(String uuid) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)uuid));
    }

    public static ResourceKey<Level> createLevelKey(ResourceLocation loc) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)loc);
    }

    public static ServerLevel createRaidDimension(MinecraftServer server, ResourceKey<Level> levelKey) {
        if (server.getLevel(levelKey) != null) {
            return server.getLevel(levelKey);
        }
        ResourceKey dimKey = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)levelKey.location());
        BiFunction<MinecraftServer, ResourceKey, LevelStem> dimensionFactory = ModDimensions::raidDimBuilder;
        LevelStem dimension = dimensionFactory.apply(server, dimKey);
        Executor executor = ((MinecraftServerAccessor)server).getExecutor();
        LevelStorageSource.LevelStorageAccess levelSave = ((MinecraftServerAccessor)server).getStorageSource();
        ChunkProgressListener chunkProgressListener = ((MinecraftServerAccessor)server).getProgressListenerFactory().create(11);
        WorldData serverConfiguration = server.getWorldData();
        Registry dimensionRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        if (dimensionRegistry instanceof WritableRegistry) {
            WritableRegistry writableRegistry = (WritableRegistry)dimensionRegistry;
            boolean wasFrozen = ((MappedRegistryAccessor)writableRegistry).getFrozen();
            ((MappedRegistryAccessor)writableRegistry).setFrozen(false);
            writableRegistry.register(dimKey, (Object)dimension, RegistrationInfo.BUILT_IN);
            if (wasFrozen) {
                ((MappedRegistryAccessor)writableRegistry).setFrozen(true);
            }
        } else {
            throw new IllegalStateException("Unable to register dimension '" + String.valueOf(dimKey.location()) + "'! Registry not writable!");
        }
        DerivedLevelData derivedWorldInfo = new DerivedLevelData(serverConfiguration, serverConfiguration.overworldData());
        ServerLevel raidDim = new ServerLevel(server, executor, levelSave, (ServerLevelData)derivedWorldInfo, levelKey, dimension, chunkProgressListener, serverConfiguration.isDebugWorld(), BiomeManager.obfuscateSeed((long)serverConfiguration.worldGenOptions().seed()), (List)ImmutableList.of(), false, null);
        ((MinecraftServerAccessor)server).getLevels().put(levelKey, raidDim);
        return raidDim;
    }

    public static void placeRaidDenStructure(RaidCrystalBlockEntity blockEntity, ServerLevel level) {
        StructureTemplateManager structureManager = level.getStructureManager();
        StructureTemplate template = structureManager.get(blockEntity.getRaidStructure()).orElseGet(() -> {
            blockEntity.setRaidStructure(RaidDenRegistry.DEFAULT);
            return structureManager.getOrCreate(blockEntity.getRaidStructure());
        });
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.clearProcessors();
        settings.addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        Vec3 offset = RaidDenRegistry.getOffset(blockEntity.getRaidStructure());
        BlockPos corner = BlockPos.containing((Position)offset);
        for (Entity e : level.getAllEntities()) {
            if (e == null) continue;
            e.discard();
        }
        template.placeInWorld((ServerLevelAccessor)level, corner, corner, settings, level.getRandom(), 2);
        level.setBlockAndUpdate(BlockPos.ZERO, ModBlocks.INSTANCE.getRaidHomeBlock().defaultBlockState());
        BlockEntity blockEntity2 = level.getBlockEntity(BlockPos.ZERO);
        if (blockEntity2 instanceof RaidHomeBlockEntity) {
            RaidHomeBlockEntity homeBlockEntity = (RaidHomeBlockEntity)blockEntity2;
            homeBlockEntity.setHome(blockEntity.getBlockPos(), (ServerLevel)blockEntity.getLevel());
        }
    }
}

