/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.items.item;

import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.events.OpenPouchEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.raids.RaidFeature;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;

public class RaidPouchItem
extends Item {
    public RaidPouchItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.UNCOMMON));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        RaidTier tier = (RaidTier)((Object)itemStack.get((DataComponentType)ModComponents.TIER_COMPONENT.value()));
        RaidFeature feature = (RaidFeature)((Object)itemStack.get((DataComponentType)ModComponents.FEATURE_COMPONENT.value()));
        RaidType raidType = (RaidType)((Object)itemStack.get((DataComponentType)ModComponents.TYPE_COMPONENT.value()));
        if (tier == null || feature == null || raidType == null) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        if (!level.isClientSide) {
            List<ItemStack> rewards = this.getRewardItems(tier, feature, (ServerLevel)level, player);
            if (!RaidEvents.OPEN_POUCH.postWithResult(new OpenPouchEvent((ServerPlayer)player, itemStack, rewards))) {
                return InteractionResultHolder.fail((Object)itemStack);
            }
            for (ItemStack item : this.getRewardItems(tier, feature, (ServerLevel)level, player)) {
                ItemEntity itemEntity;
                if (player.getInventory().add(item) || (itemEntity = player.drop(item, false)) == null) continue;
                itemEntity.setNoPickUpDelay();
                itemEntity.setTarget(player.getUUID());
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            itemStack.consume(1, (LivingEntity)player);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        RaidTier tier = (RaidTier)((Object)stack.get((DataComponentType)ModComponents.TIER_COMPONENT.value()));
        RaidFeature feature = (RaidFeature)((Object)stack.get((DataComponentType)ModComponents.FEATURE_COMPONENT.value()));
        if (tier == null || feature == null) {
            return;
        }
        tooltip.add((Component)Component.translatable((String)feature.getTranslatable()).append(" | ").append(tier.getStars()));
    }

    private List<ItemStack> getRewardItems(RaidTier tier, RaidFeature feature, ServerLevel level, Player player) {
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>(this.getTierRewards(tier, level, player));
        rewards.addAll(this.getFeatureRewards(feature, level, player));
        return rewards;
    }

    private List<ItemStack> getTierRewards(RaidTier tier, ServerLevel level, Player player) {
        return level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)tier.getLootTableId()))).getRandomItems(new LootParams.Builder(level).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSet.builder().optional(LootContextParams.THIS_ENTITY).build()));
    }

    private List<ItemStack> getFeatureRewards(RaidFeature feature, ServerLevel level, Player player) {
        return level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)feature.getLootTableId()))).getRandomItems(new LootParams.Builder(level).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSet.builder().optional(LootContextParams.THIS_ENTITY).build()));
    }
}

