/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.util.IHealthSetter;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonEntityMixin
extends TamableAnimal
implements IRaidAccessor {
    @Unique
    private UUID raidId;
    @Unique
    private ResourceLocation raidBoss;

    @Shadow(remap=false)
    public abstract void setBattleId(@Nullable UUID var1);

    @Shadow(remap=false)
    public abstract Pokemon getPokemon();

    protected PokemonEntityMixin(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public UUID getRaidId() {
        return this.raidId;
    }

    @Override
    public void setRaidId(UUID raidId) {
        this.raidId = null;
        this.setBattleId(raidId);
        this.raidId = raidId;
    }

    @Override
    public boolean isRaidBoss() {
        return this.getPokemon().getAspects().contains("raid") || this.getPokemon().getForcedAspects().contains("raid") || this.raidBoss != null;
    }

    @Override
    public RaidBoss getRaidBoss() {
        return RaidRegistry.getRaidBoss(this.raidBoss);
    }

    @Override
    public void setRaidBoss(ResourceLocation raidBoss) {
        this.raidBoss = raidBoss;
    }

    @Inject(method={"canBattle(Lnet/minecraft/world/entity/player/Player;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void canBattleInject(Player player, CallbackInfoReturnable<Boolean> cir) {
        if (this.level().isClientSide()) {
            cir.setReturnValue((Object)true);
        }
        if (this.getRaidId() == null) {
            return;
        }
        if (this.getHealth() <= 0.0f || this.isDeadOrDying() || PlayerExtensionsKt.isPartyBusy((Player)player)) {
            cir.setReturnValue((Object)false);
        }
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"setBattleId(Ljava/util/UUID;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void setBattleInject(UUID battleId, CallbackInfo ci) {
        if (this.getRaidId() != null) {
            ci.cancel();
        }
    }

    @Inject(method={"isBattling()Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void isBattlingInject(CallbackInfoReturnable<Boolean> cir) {
        if (this.getRaidId() != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="RETURN")})
    private void saveWithoutIdInject(CompoundTag nbt, CallbackInfoReturnable<CompoundTag> cir) {
        if (this.raidId != null) {
            nbt.putString("raid_id", this.raidId.toString());
        }
        if (this.raidBoss != null) {
            nbt.putString("raid_boss", this.raidBoss.toString());
        }
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="RETURN")})
    private void loadInject(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.contains("raid_id")) {
            this.raidId = UUID.fromString(nbt.getString("raid_id"));
        }
        if (nbt.contains("raid_boss")) {
            this.raidBoss = ResourceLocation.parse((String)nbt.getString("raid_boss"));
        }
        if (this.getPokemon() == null) {
            return;
        }
        CompoundTag tag = nbt.getCompound("Pokemon");
        if (tag.contains("max_health_buffer")) {
            ((IHealthSetter)this.getPokemon()).setMaxHealth(tag.getInt("max_health_buffer"));
        }
    }
}

