/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.reloaders;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.raids.RaidBossAdditions;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.reloaders.AbstractReloadImpl;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class BossAdditionsReloadImpl
extends AbstractReloadImpl {
    private List<ResourceLocation> registry = null;

    public BossAdditionsReloadImpl() {
        super("raid/boss_additions", AbstractReloadImpl.DataType.JSON);
    }

    @Override
    protected void preLoad() {
    }

    @Override
    protected void onLoad(ResourceLocation key, JsonObject object) {
        if (this.registry == null) {
            this.registry = new ArrayList<ResourceLocation>(RaidRegistry.getAll());
        }
        Optional<RaidBossAdditions> additionsOpt = RaidBossAdditions.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)object).result().map(Pair::getFirst);
        additionsOpt.ifPresent(additions -> additions.apply(this.registry));
    }

    @Override
    protected void onError(ResourceLocation id, Exception e) {
        CobblemonRaidDens.LOGGER.error("Failed to load boss additions {}", (Object)id, (Object)e);
    }

    @Override
    protected void postLoad() {
        RaidRegistry.registerAll();
        RaidTier.updateRandom();
    }
}

