/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.util;

import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidFeature;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RaidRegistry {
    public static final ResourceKey<Registry<RaidBoss>> RAID_BOSS_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"raid", (String)"boss"));
    public static Registry<RaidBoss> REGISTRY;
    static final Map<RaidTier, BitSet> RAIDS_BY_TIER;
    static final Map<RaidType, BitSet> RAIDS_BY_TYPE;
    static final Map<RaidFeature, BitSet> RAIDS_BY_FEATURE;
    static final List<ResourceLocation> RAID_LIST;
    static final Map<ResourceLocation, RaidBoss> RAID_LOOKUP;
    static final Map<ResourceLocation, Integer> RAID_INDEX;
    static Map<ResourceLocation, Set<ResourceLocation>> RAID_TAGS;
    static final Map<String, float[]> WEIGHTS_CACHE;
    static final Map<String, int[]> INDEX_CACHE;

    public static void register(RaidBoss raidBoss) {
        if (raidBoss.getProperties().getSpecies() == null) {
            return;
        }
        int index = RAID_LIST.size();
        RAID_LIST.add(raidBoss.getId());
        RAID_LOOKUP.put(raidBoss.getId(), raidBoss);
        RAID_INDEX.put(raidBoss.getId(), index);
    }

    public static void registerAll() {
        for (int index = 0; index < RAID_LIST.size(); ++index) {
            RaidBoss raidBoss = RaidRegistry.getRaidBoss(RAID_LIST.get(index));
            RAIDS_BY_TIER.computeIfAbsent(raidBoss.getTier(), tier -> new BitSet()).set(index);
            RAIDS_BY_TYPE.computeIfAbsent(raidBoss.getType(), type -> new BitSet()).set(index);
            RAIDS_BY_FEATURE.computeIfAbsent(raidBoss.getFeature(), feature -> new BitSet()).set(index);
            if (!(raidBoss.getWeight() > 0.0)) continue;
            raidBoss.getTier().setPresent();
            raidBoss.getType().setPresent();
        }
    }

    public static List<ResourceLocation> getAll() {
        return RAID_LIST;
    }

    public static RaidBoss getRaidBoss(ResourceLocation location) {
        return RAID_LOOKUP.get(location);
    }

    public static boolean exists(ResourceLocation location) {
        return RAID_LOOKUP.containsKey(location);
    }

    public static void setTags(Map<ResourceLocation, Set<ResourceLocation>> tags) {
        RAID_TAGS = tags;
    }

    public static boolean isTag(ResourceLocation tag, ResourceLocation boss) {
        if (!RAID_TAGS.containsKey(tag)) {
            return false;
        }
        return RAID_TAGS.get(tag).contains(boss);
    }

    public static Set<ResourceLocation> getTagEntries(ResourceLocation tag) {
        return RAID_TAGS.getOrDefault(tag, new HashSet());
    }

    private static float[] buildWeights(int[] matches, Level level) {
        float[] weights = new float[matches.length];
        float sum = 0.0f;
        for (int i = 0; i < matches.length; ++i) {
            RaidBoss raidBoss = RAID_LOOKUP.get(RAID_LIST.get(matches[i]));
            weights[i] = sum += (float)(raidBoss.getWeight() * raidBoss.getTier().getWeight(level));
        }
        return weights;
    }

    static ResourceLocation roll(RandomSource random, float[] weights, int[] indexes) {
        float roll = random.nextFloat() * weights[weights.length - 1];
        int idx = Arrays.binarySearch(weights, roll);
        if (idx < 0) {
            idx = -idx - 1;
        }
        return RAID_LIST.get(indexes[idx]);
    }

    static ResourceLocation getRandomRaidBoss(RandomSource random, Level level, BitSet bitSet, @Nullable String cacheKey) {
        int size = bitSet.cardinality();
        if (size == 0) {
            return null;
        }
        int[] matches = new int[size];
        int i = bitSet.nextSetBit(0);
        int idx = 0;
        while (i >= 0) {
            matches[idx] = i;
            i = bitSet.nextSetBit(i + 1);
            ++idx;
        }
        float[] cachedWeights = RaidRegistry.buildWeights(matches, level);
        if (cacheKey != null) {
            WEIGHTS_CACHE.put(cacheKey, cachedWeights);
            INDEX_CACHE.put(cacheKey, matches);
        }
        return RaidRegistry.roll(random, cachedWeights, matches);
    }

    public static ResourceLocation getRandomRaidBoss(RandomSource random, Level level, List<RaidTier> tiers, List<RaidType> types, List<RaidFeature> features) {
        BitSet set;
        if (tiers == null || tiers.isEmpty()) {
            return null;
        }
        boolean cacheable = !(tiers.size() != 1 || types != null && types.size() > 1 || features != null && !features.isEmpty());
        String key = String.valueOf(level.dimension().location()) + ":" + String.valueOf((Object)tiers.getFirst()) + ":" + String.valueOf(types == null ? null : types.getFirst());
        if (cacheable && WEIGHTS_CACHE.containsKey(key)) {
            return RaidRegistry.roll(random, WEIGHTS_CACHE.get(key), INDEX_CACHE.get(key));
        }
        BitSet result = new BitSet();
        for (RaidTier tier : tiers) {
            BitSet set2 = RAIDS_BY_TIER.get((Object)tier);
            if (set2 == null) continue;
            result.or(set2);
        }
        if (types != null && !types.isEmpty()) {
            BitSet typeSet = new BitSet();
            for (RaidType type : types) {
                set = RAIDS_BY_TYPE.get((Object)type);
                if (set == null) continue;
                typeSet.or(set);
            }
            result.and(typeSet);
        }
        if (features != null && !features.isEmpty()) {
            BitSet featureSet = new BitSet();
            for (RaidFeature feature : features) {
                set = RAIDS_BY_FEATURE.get((Object)feature);
                if (set == null) continue;
                featureSet.or(set);
            }
            result.and(featureSet);
        }
        return RaidRegistry.getRandomRaidBoss(random, level, result, (String)((Object)(cacheable ? key : null)));
    }

    public static ResourceLocation getRandomRaidBoss(RandomSource random, Level level, RaidTier tier, RaidType type, RaidFeature feature) {
        return RaidRegistry.getRandomRaidBoss(random, level, List.of(tier), type == null ? null : List.of(type), feature == null ? null : List.of(feature));
    }

    public static ResourceLocation getRandomRaidBoss(RandomSource random, Level level, RaidType type, RaidFeature feature) {
        return RaidRegistry.getRandomRaidBoss(random, level, RaidTier.getWeightedRandom(random, level), type, feature);
    }

    public static ResourceLocation getRandomRaidBoss(RandomSource random, Level level) {
        return RaidRegistry.getRandomRaidBoss(random, level, (RaidType)null, null);
    }

    public static void clear() {
        RAIDS_BY_TIER.values().forEach(BitSet::clear);
        RAIDS_BY_TYPE.values().forEach(BitSet::clear);
        RAIDS_BY_FEATURE.values().forEach(BitSet::clear);
        RAID_LIST.clear();
        RAID_LOOKUP.clear();
        RAID_INDEX.clear();
        WEIGHTS_CACHE.clear();
        INDEX_CACHE.clear();
        for (RaidTier raidTier : RaidTier.values()) {
            raidTier.setPresent(false);
        }
        for (Enum enum_ : RaidType.values()) {
            ((RaidType)enum_).setPresent(false);
        }
    }

    public static void initRaidBosses(MinecraftServer server) {
        REGISTRY = server.registryAccess().registryOrThrow(RAID_BOSS_KEY);
    }

    static {
        RAIDS_BY_TIER = new EnumMap<RaidTier, BitSet>(RaidTier.class);
        RAIDS_BY_TYPE = new EnumMap<RaidType, BitSet>(RaidType.class);
        RAIDS_BY_FEATURE = new EnumMap<RaidFeature, BitSet>(RaidFeature.class);
        RAID_LIST = new ArrayList<ResourceLocation>();
        RAID_LOOKUP = new HashMap<ResourceLocation, RaidBoss>();
        RAID_INDEX = new HashMap<ResourceLocation, Integer>();
        RAID_TAGS = new HashMap<ResourceLocation, Set<ResourceLocation>>();
        WEIGHTS_CACHE = new HashMap<String, float[]>();
        INDEX_CACHE = new HashMap<String, int[]>();
    }
}

