/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.neoforge.compat.megashowdown;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.yajatkaul.mega_showdown.event.cobblemon.utils.DynamaxUtils;
import com.cobblemon.yajatkaul.mega_showdown.item.DynamaxItems;
import com.cobblemon.yajatkaul.mega_showdown.item.TeraMoves;
import com.cobblemon.yajatkaul.mega_showdown.sound.ModSounds;
import com.cobblemon.yajatkaul.mega_showdown.utility.GlowHandler;
import com.necro.raid.dens.common.compat.megashowdown.RaidDensMSDCompat;
import com.necro.raid.dens.common.raids.RaidType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class NeoForgeMSDCompat
extends RaidDensMSDCompat {
    @Override
    public void setupTera(PokemonEntity pokemonEntity, Pokemon pokemon) {
        Vec3 entityPos = pokemonEntity.position();
        pokemonEntity.level().playSound(null, entityPos.x(), entityPos.y(), entityPos.z(), (SoundEvent)ModSounds.TERASTALLIZATION.get(), SoundSource.PLAYERS, 0.2f, 1.0f);
        pokemon.getPersistentData().putBoolean("is_tera", true);
        GlowHandler.applyTeraGlow((PokemonEntity)pokemonEntity);
    }

    @Override
    public void setupDmax(PokemonEntity pokemonEntity) {
        Level level;
        Vec3 entityPos = pokemonEntity.position();
        pokemonEntity.level().playSound(null, entityPos.x(), entityPos.y(), entityPos.z(), (SoundEvent)ModSounds.DYNAMAX.get(), SoundSource.PLAYERS, 0.4f, 0.5f + (float)Math.random() * 0.5f);
        if (DynamaxUtils.server == null && (level = pokemonEntity.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            DynamaxUtils.server = serverWorld.getServer();
        }
        GlowHandler.applyDynamaxGlow((PokemonEntity)pokemonEntity);
    }

    @Override
    public ItemStack getTeraShard(RaidType raidType) {
        return switch (raidType) {
            case RaidType.FIGHTING -> ((Item)TeraMoves.FIGHTING_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FLYING -> ((Item)TeraMoves.FLYING_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.POISON -> ((Item)TeraMoves.POISON_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GROUND -> ((Item)TeraMoves.GROUND_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ROCK -> ((Item)TeraMoves.ROCK_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.BUG -> ((Item)TeraMoves.BUG_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GHOST -> ((Item)TeraMoves.GHOST_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.STEEL -> ((Item)TeraMoves.STEEL_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FIRE -> ((Item)TeraMoves.FIRE_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.WATER -> ((Item)TeraMoves.WATER_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.GRASS -> ((Item)TeraMoves.GRASS_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ELECTRIC -> ((Item)TeraMoves.ELECTRIC_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.PSYCHIC -> ((Item)TeraMoves.PSYCHIC_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.ICE -> ((Item)TeraMoves.ICE_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.DRAGON -> ((Item)TeraMoves.DRAGON_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.DARK -> ((Item)TeraMoves.DARK_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.FAIRY -> ((Item)TeraMoves.FAIRY_TERA_SHARD.get()).getDefaultInstance();
            case RaidType.STELLAR -> ((Item)TeraMoves.STELLAR_TERA_SHARD.get()).getDefaultInstance();
            default -> ((Item)TeraMoves.NORMAL_TERA_SHARD.get()).getDefaultInstance();
        };
    }

    @Override
    public ItemStack getMaxMushroom() {
        return ((Item)DynamaxItems.MAX_MUSHROOM.get()).getDefaultInstance();
    }

    public static void init() {
        INSTANCE = new NeoForgeMSDCompat();
    }
}

