/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.client.gui.screens;

import com.necro.raid.dens.common.CobblemonRaidDensClient;
import com.necro.raid.dens.common.client.gui.RaidScreenComponents;
import com.necro.raid.dens.common.client.gui.buttons.AbstractRaidButton;
import com.necro.raid.dens.common.client.gui.components.LogComponent;
import com.necro.raid.dens.common.client.gui.screens.AbstractOverlay;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class RaidOverlay
extends AbstractOverlay {
    private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"textures/gui/raid/overlay.png");
    private static final int OVERLAY_WIDTH = 40;
    private static final int OVERLAY_HEIGHT = 34;
    private final List<LogComponent> battleLog = new ArrayList<LogComponent>();

    public void addLog(Component log) {
        if (this.battleLog.size() > 3) {
            this.battleLog.removeFirst();
        }
        this.battleLog.add(new LogComponent(log));
    }

    @Override
    public void render(GuiGraphics guiGraphics, int maxX, int maxY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        int x = maxX - 40;
        int y = (int)((double)maxY * 0.4);
        guiGraphics.blit(OVERLAY, x, y, 0.0f, 0.0f, 40, 34, 40, 34);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x, (float)y, 0.0f);
        guiGraphics.pose().scale(0.5f, 0.5f, 1.0f);
        MutableComponent component = Component.translatable((String)"screen.cobblemonraiddens.raid.title");
        List wrapped = font.split((FormattedText)component, 74);
        int textY = 12;
        for (FormattedCharSequence text : wrapped) {
            guiGraphics.drawCenteredString(font, text, 40, textY, 0xFFFFFF);
            textY += 12;
        }
        guiGraphics.pose().popPose();
        if (CobblemonRaidDensClient.CLIENT_CONFIG.enable_raid_logs) {
            int logX = 0;
            int logY = (int)((double)maxY * 0.3);
            for (int i = 0; i < this.battleLog.size(); ++i) {
                this.battleLog.get(i).render(guiGraphics, logX, logY + i * 18, partialTick);
            }
        }
        RaidScreenComponents.LEAVE_RAID_BUTTON.setX(x + 4);
        RaidScreenComponents.LEAVE_RAID_BUTTON.setY(y + 18);
        RaidScreenComponents.LEAVE_RAID_BUTTON.renderStatic(guiGraphics);
    }

    @Override
    public List<AbstractRaidButton> getButtons() {
        return List.of(RaidScreenComponents.LEAVE_RAID_BUTTON);
    }

    public void tick() {
        this.battleLog.removeIf(LogComponent::tick);
    }
}

