/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.network.packets;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSeenEvent;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.events.RaidBattleStartEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.network.ServerPacket;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidBuilder;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.RaidUtils;
import java.util.Optional;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public record RaidChallengePacket(int targetedEntityId, UUID selectedPokemonId, BattleFormat battleFormat) implements CustomPacketPayload,
ServerPacket
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_challenge");
    public static final CustomPacketPayload.Type<RaidChallengePacket> PACKET_TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, RaidChallengePacket> CODEC = StreamCodec.ofMember(RaidChallengePacket::write, RaidChallengePacket::read);

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.targetedEntityId);
        buf.writeUUID(this.selectedPokemonId);
        this.battleFormat.saveToBuffer((RegistryFriendlyByteBuf)buf);
    }

    public static RaidChallengePacket read(FriendlyByteBuf buf) {
        return new RaidChallengePacket(buf.readInt(), buf.readUUID(), BattleFormat.Companion.loadFromBuffer((RegistryFriendlyByteBuf)buf));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    @Override
    public void handleServer(ServerPlayer player) {
        PokemonEntity pokemonEntity;
        if (!RaidHelper.isAlreadyParticipating((Player)player) && !RaidHelper.isAlreadyHosting((Player)player)) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.not_participating").withStyle(ChatFormatting.RED));
            return;
        }
        Entity entity = player.level().getEntity(this.targetedEntityId);
        if (!(entity instanceof PokemonEntity) || (pokemonEntity = (PokemonEntity)entity).getOwner() != null) {
            return;
        }
        if (!((IRaidAccessor)pokemonEntity).isRaidBoss()) {
            return;
        }
        UUID raidId = ((IRaidAccessor)pokemonEntity).getRaidId();
        if (RaidHelper.ACTIVE_RAIDS.containsKey(raidId) && RaidHelper.ACTIVE_RAIDS.get(raidId).hasFailed(player)) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.has_fainted").withStyle(ChatFormatting.RED));
            return;
        }
        Pokemon pokemon = PlayerExtensionsKt.party((ServerPlayer)player).get(this.selectedPokemonId);
        if (pokemon == null) {
            return;
        }
        if (RaidUtils.isPokemonBlacklisted(pokemon)) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.forbidden_pokemon", (Object[])new Object[]{pokemon.getSpecies().getTranslatedName()}).withStyle(ChatFormatting.RED));
            return;
        }
        if (RaidUtils.isAbilityBlacklisted(pokemon.getAbility())) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.forbidden_ability", (Object[])new Object[]{Component.translatable((String)pokemon.getAbility().getDisplayName())}).withStyle(ChatFormatting.RED));
            return;
        }
        if (pokemon.isFainted()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.cobblemonraiddens.raid.fainted_lead", (Object[])new Object[]{pokemon.getSpecies().getTranslatedName()}).withStyle(ChatFormatting.RED));
            return;
        }
        UUID leadingPokemon = pokemon.getUuid();
        if (PlayerExtensionsKt.canInteractWith((ServerPlayer)player, (LivingEntity)pokemonEntity, (float)(Cobblemon.config.getBattleWildMaxDistance() * 4.0f)) && pokemonEntity.canBattle((Player)player)) {
            RaidBoss boss = ((IRaidAccessor)entity).getRaidBoss();
            RaidBuilder.build(player, pokemonEntity, leadingPokemon, CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).raidPartySize()).ifSuccessful(battle -> {
                this.flagAsSeen((PokemonBattle)battle, pokemonEntity);
                UUID raidId2 = raidId;
                if (!RaidHelper.ACTIVE_RAIDS.containsKey(raidId2)) {
                    ((IRaidAccessor)pokemonEntity).setRaidId(battle.getBattleId());
                    raidId2 = ((IRaidAccessor)pokemonEntity).getRaidId();
                    RaidHelper.ACTIVE_RAIDS.put(raidId2, new RaidInstance(pokemonEntity));
                }
                RaidInstance raidInstance = RaidHelper.ACTIVE_RAIDS.get(raidId2);
                raidInstance.addPlayer((PokemonBattle)battle);
                RaidEvents.RAID_BATTLE_START.emit((Object[])new RaidBattleStartEvent[]{new RaidBattleStartEvent(player, boss, (PokemonBattle)battle)});
                return Unit.INSTANCE;
            }).ifErrored(errors -> {
                errors.sendTo((Entity)player, component -> component.withStyle(ChatFormatting.RED));
                return Unit.INSTANCE;
            });
        }
    }

    private void flagAsSeen(PokemonBattle battle, PokemonEntity entity) {
        PokemonBattleActor actor = (PokemonBattleActor)battle.getActor(entity.getPokemon().getUuid());
        if (actor == null) {
            return;
        }
        Optional<BattlePokemon> battlePokemon = actor.getPokemonList().stream().filter(bp -> bp.getUuid() == entity.getPokemon().getUuid()).findFirst();
        if (battlePokemon.isEmpty()) {
            return;
        }
        battle.getPlayerUUIDs().forEach(uuid -> CobblemonEvents.POKEMON_SEEN.post((Object[])new PokemonSeenEvent[]{new PokemonSeenEvent(uuid, ((BattlePokemon)battlePokemon.get()).getEffectedPokemon())}, T -> Unit.INSTANCE));
    }
}

