/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.network.packets;

import com.necro.raid.dens.common.client.gui.RaidDenGuiManager;
import com.necro.raid.dens.common.client.gui.screens.RaidRewardOverlay;
import com.necro.raid.dens.common.network.ClientPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record RewardPacket(boolean isCatchable, String pokemon) implements CustomPacketPayload,
ClientPacket
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"cobblemonraiddens", (String)"raid_reward");
    public static final CustomPacketPayload.Type<RewardPacket> PACKET_TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, RewardPacket> CODEC = StreamCodec.ofMember(RewardPacket::write, RewardPacket::read);

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isCatchable);
        buf.writeUtf(this.pokemon);
    }

    public static RewardPacket read(FriendlyByteBuf buf) {
        return new RewardPacket(buf.readBoolean(), buf.readUtf());
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }

    @Override
    public void handleClient() {
        RaidDenGuiManager.OVERLAY_QUEUE.add(new RaidRewardOverlay(this.isCatchable, this.pokemon));
    }
}

